package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowDragController;

public class TitleListTableRowDragController extends TableRowDragController {

	public TitleListTableRowDragController( AbsolutePanel boundaryPanel, FlexTable table ) {
		super( boundaryPanel, table );
	}
	
	/**
	 * Provide a widget to show as the drag proxy so that the user is aware of the contents being
	 * dragged.
	 * 
	 * @see com.allen_sauer.gwt.dnd.client.PickupDragController#newDragProxy(com.allen_sauer.gwt.dnd.client.DragContext)
	 */
	@Override
	protected Widget newDragProxy(DragContext context) {
		setDraggedRowIndex( getDragRowIndex(context) );

		/* no matching row found */
		if (getDraggedRowIndex() == -1) {
			return null;
		}

		/* create the drag proxy widget - a table with a single row (the dragged row) */
		FlexTableContainer proxyTable = new FlexTableContainer();
		proxyTable.setStyleName(getTable().getStyleName());

		/* Limit the table width to the width of current table */
		proxyTable.setWidth(getTable().getOffsetWidth() + "px");

		/* add dragged row and the expansion row to the proxy widget */
		proxyTable.insertRow(0);
		proxyTable.insertRow(1);
		String rowStyle = getTable().getRowFormatter().getStyleName(getDraggedRowIndex());
		proxyTable.getRowFormatter().setStyleName(0, rowStyle);

		/* add a copy of all the cells from the dragged row to the new proxy row */
		for (int column = 0; column < getTable().getCellCount(getDraggedRowIndex()); column++) {
			HTML contents = new HTML(getTable().getHTML(getDraggedRowIndex(), column));
			String cellStyle = getTable().getCellFormatter().getStyleName(getDraggedRowIndex(), column);
			proxyTable.setWidget(0, column, contents);
			proxyTable.getCellFormatter().setStyleName(0, column, cellStyle);
		}
		
		/* add a copy of all the cells from the expansion of the dragged row to the new proxy row */
		for (int column = 0; column < getTable().getCellCount(getDraggedRowIndex()+1); column++) {
			HTML contentsExpansionRow = new HTML(getTable().getHTML(getDraggedRowIndex()+1, column));
			String cellStyleExpansionRow = getTable().getCellFormatter().getStyleName(getDraggedRowIndex()+1, column);
			proxyTable.setWidget(1, column, contentsExpansionRow);
			proxyTable.getCellFormatter().setStyleName(1, column, cellStyleExpansionRow);
		}

		return proxyTable;
	}

}
