package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.ButtonClickListener;
import com.tandbergtv.cms.portal.content.titlelist.client.Permissions;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListsDataProvider.IBusyNotifier;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleListActionInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Table that shows the list of titlelists.
 * 
 * @author spuranik
 * 
 */
public class TitleListsPanel extends Composite implements IView {
	// input
	private String spec;
	private ServiceLoader serviceLoader;
	
	private NeptuneSecurity security;
	
	// table related
	private TitleListsDataProvider dataProvider;
	private PageFeature pageFeature;
	private SortFeatureImpl<UiTitleListKey, UiTitleListRecord> sortFeature;
	private BookmarkFeature bookmarkFeature;
	private TitleListDetailFeature detailFeature;
	private AnchorChangeListener anchorChangeListener;
	
	// widgets used in this view 
	private VerticalContainer mainContainer;
	private Table<UiTitleListKey, UiTitleListRecord> table;
	private ListBoxWidget<String> actionsListBox;
	private ButtonWidget goButton;
	private Button createButton;
	private ListBoxWidget<String> parameterListBox;
	private HorizontalContainer actionListContainer;
	private BusyIndicator busyIndicator = new BusyIndicator();
	private ResizableContainer resizableContainer;
	// message panels
	private MessageArea messageArea; 
	private HeaderPanel header;
	
	private TitleListConstants constants = (TitleListConstants) GWT.create(TitleListConstants.class);
	
	// spacing between the table and message panel 
	private static final int SPACING = 2;
	private static final String STYLE_NAME = "content-TitleListsPanel";

	public TitleListsPanel(String specification, NeptuneSecurity security, ServiceLoader serviceLoader) {
		this.spec = specification;
		this.serviceLoader = serviceLoader;
		this.security = security;
		this.dataProvider = new TitleListsDataProvider(this);
		messageArea = new MessageArea();	
		dataProvider.setBusyNotifier(new IBusyNotifier() {
			@Override
			public void startingToBeBusy() {
				busyIndicator.center();
			}
			
			@Override
			public void doneBeingBusy() {
				busyIndicator.hide();
			}});
		init();
	}

	private void init() {
		initWidgets();
		setContainers();
	}
	
	private void setContainers() {
		mainContainer.add(header);
		mainContainer.add(messageArea);
		
		mainContainer.add(resizableContainer);
	}

	private void initWidgets() {
		mainContainer = new VerticalContainer();
		createButton = new Button("Create");
		createButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		createButton.addStyleName(StyleNames.STYLE_EB_BTN);
		createButton.addStyleName(StyleNames.STYLE_EB_BTN_COLOR_GREEN);
		createButton.addStyleName(StyleNames.STYLE_CREATE_BUTTON_ICON);
		mainContainer.setSpacing(SPACING);
		mainContainer.setStylePrimaryName(STYLE_NAME);
		this.initWidget(mainContainer);
		
		header = new HeaderPanel("");
		header.setStyleName("content-header-style");
		buildActionsListWidget();
		table = new Table<UiTitleListKey, UiTitleListRecord>(dataProvider);
		resizableContainer = new ResizableContainer(table,"Title Lists", null);
		resizableContainer.addBottomWidget("Title Lists", actionListContainer);
		table.addTableViewChangeHandler(new TableViewChangeHandler<UiTitleListKey, UiTitleListRecord>() {
			@Override
			public void onShowDetailView(
					TableDetailViewEvent<UiTitleListKey, UiTitleListRecord> event) {
				
				
				if(event.isCreateView()) {
					header.setLabel(constants.titleListCreateHeading());
				} else {
					header.setLabel(constants.titleListViewEditHeading()
							+ " " + event.getRecord().getTitleList().getName());
				}
			}

			@Override
			public void onShowListView(TableViewEvent event) {
				header.setLabel(constants.titleListListHeading());
			}});

		// page feature
		pageFeature = new CookieStoreBasedPageFeatureImpl("cms-titlelists");
		dataProvider.setParentPageFeature(pageFeature);
		
		// sort feature
		sortFeature = new SortFeatureImpl<UiTitleListKey, UiTitleListRecord>(
				dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
		for (Column<?, UiTitleListRecord> col : dataProvider.getSortColumns()) {
			sortFeature.addSortableColumn(col);
		}
		dataProvider.setParentSortFeature(sortFeature);
		
		// bookmark feature
		bookmarkFeature = new BookmarkFeatureImpl();
		
		// detail feature
		detailFeature = new TitleListDetailFeature(spec, security, this);
		 
		table.addSortFeature(sortFeature);
		table.addPageFeature(pageFeature);
		table.addDetailFeature(detailFeature);
		table.addBookmarkFeature(bookmarkFeature);
		
		table.initialize(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}

			@Override
			public void onNeptuneSuccess(Void result) {
			}});
			anchorChangeListener = new TitleListAnchorChangeListener(this);
			resizableContainer.addHeightOffsettingWidget(header);
			resizableContainer.addHeightOffsettingWidget(messageArea);
			resizableContainer.setOffsetHeight(10);

	}

	private void buildActionsListWidget() {
		actionListContainer = new HorizontalContainer();
		
		// create actions listbox. When the user selects one of these services, show the parameters 
		// for this service if any.
		actionsListBox = new ListBoxWidget<String>(false);
		
		// service parameter list
		parameterListBox = new ListBoxWidget<String>(false);
		parameterListBox.setVisible(false);
		
		//add action items to actions listbox
		final ServiceMap serviceMap = new ServiceMap();
		ActionListDataProvider<ITitleListService> listItemProvider = new ActionListDataProvider<ITitleListService>(
				ITitleListService.class, serviceLoader, false);
		for (UiServiceItem item : listItemProvider.getItems(serviceMap)) {
			actionsListBox.addItem(item.getName(), item.getClassName());
		}
		
		//create go button & connect to actions listbox
		goButton = new ButtonWidget(constants.titleListsGoButtonName());
		goButton.addClickHandler(new ButtonClickListener(actionsListBox, parameterListBox, this, serviceMap));
		goButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		goButton.addStyleName(StyleNames.STYLE_EB_BTN);
		goButton.addStyleName(StyleNames.STYLE_DARK_BLUE_BUTTON_ICON);
		goButton.addStyleName(StyleNames.STYLE_NEXT_BUTTON_ICON);				
		createButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
		
				History.newItem("Content.TitleLists.Create");
			}

		});
		setWidgetsForNoAction();
		
		// show parameter list corresponding to the selected service
		actionsListBox.addChangeHandler(new ChangeHandler() {
			public void onChange(ChangeEvent event) {
				// Don't show the parameter list box and go button until the
				// parameters have been retrieved.
				parameterListBox.setVisible(false);
				goButton.setEnabled(false);

				int selectedIndex = actionsListBox.getSelectedIndex();
				String displayName = actionsListBox.getItemText(selectedIndex);
				// if no action is selected, clear out the state
				if(displayName.trim().isEmpty()) {
					setWidgetsForNoAction();
					return;
				}
				
				ITitleActionService selectedAction = serviceMap.getService(displayName);
				selectedAction.getServiceParameters(new NeptuneAsyncCallback<List<String>>() {
					public void onNeptuneFailure(Throwable caught) {
						// In case of an exception at the very least
						// show the Go button for any
						// other operation.
						parameterListBox.setVisible(false);
						TitleListsPanel.this.reportFailure(caught);
					}

					public void onNeptuneSuccess(List<String> result) {
						// Only if there are any parameters for this
						// service, show them and
						// also enable the GO button
						if (result != null) {
							setParameterList(result);
							parameterListBox.setVisible(true);
						}
						goButton.setEnabled(true);
					}
				});
			}

			private void setParameterList(List<String> parameters) {
				parameterListBox.clear();
				for (String p : parameters) {
					parameterListBox.addItem(p, p);
				}
			}
		});
		actionListContainer.addStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
		actionListContainer.add(createButton);
		if (!ClientAuthorizationManager.isAuthorized(Permissions.TITLELIST_CREATE)) {
			createButton.setVisible(false);
		}
		
		
		//add actions listbox to container
		
		
		actionListContainer.add(actionsListBox);
		
		//add service parameters to the container.
		actionListContainer.add(parameterListBox);
		
		
		//add GO Button to container
		actionListContainer.add(goButton);
		
	}

	private void setWidgetsForNoAction() {
		actionsListBox.setSelectedItem("");
		parameterListBox.clear();
		parameterListBox.setVisible(false);
		goButton.setEnabled(false);		
	}
	
	Table<UiTitleListKey, UiTitleListRecord> getTitleListsTable() {
	    return this.table;
	}
	
	public void reportFailure(Throwable caught) {
		// show the error message along with the current state
		if(caught instanceof UiValidationException) {
			String messages = "";
			for( String message : ( ( UiValidationException )caught ).getErrorCodes() ) {
				messages += message + "\n";
			}
			messageArea.setErrorMessage(messages);
			
		} else {
			messageArea.setErrorMessage(caught.getMessage());
			
		}
		resizableContainer.updateSize();
	}

	public AnchorChangeListener getAnchorChangeListener() {
		return this.anchorChangeListener;
	}

	@Override
	public void cleanup() {
		this.messageArea.reset();
		
	}

	public void removeResizableContainer() {
		this.mainContainer.remove(resizableContainer);
		this.mainContainer.clear();
		
	}
	public ResizableContainer getResizableContainer() {
		return resizableContainer;
	}

	public void setResizableContainer(ResizableContainer resizableContainer) {
		this.resizableContainer = resizableContainer;
	}

	@Override
	public IActionInput getInputToExecution() {
		return new TitleListActionInput(spec);
	}

	@Override
	public Widget getParentContainer() {
		return mainContainer;
	}

	@Override
	public List<Long> getSeletedRecordIds() {
		List<UiTitleListRecord> selectedIds = table.getSelectedRecords();
		List<Long> ids = new ArrayList<Long>();
		for (UiTitleListRecord tr : selectedIds) {
			ids.add(tr.getKey().getId());
		}
		return ids;
	}

	@Override
	public void refresh(String infoMessage) {

		
		mainContainer.clear();
		resizableContainer = new ResizableContainer(table,"Title Lists", null);
		resizableContainer.addBottomWidget("Title Lists", actionListContainer);
		resizableContainer.addHeightOffsettingWidget(header);
		resizableContainer.addHeightOffsettingWidget(messageArea);
		resizableContainer.setOffsetHeight(10);
		resizableContainer.getTabContainer().getTabBar().setVisible(false);
		setContainers();
		/* Return to the first page and show the updated list view of the table */
		this.table.getPageFeature().setPageNumber(1);
		this.table.showListView();
		this.table.refresh();
		this.table.updateAnchor();
		resizableContainer.updateSize();
		show(infoMessage);
		setWidgetsForNoAction();
	
	}
	

	@Override
	public void show(String infoMessage) {
		if(infoMessage != null && !infoMessage.isEmpty()) {
			
	
			messageArea.setInfoMessage(infoMessage);
		} else {
			
		}
		resizableContainer.updateSize();
	}

	@Override
	public void show(boolean readOnly) {
		this.goButton.setEnabled(readOnly);
		this.actionsListBox.setEnabled(readOnly);
		this.parameterListBox.setEnabled(readOnly);
	}

	/**
	 * @param reverseAnchorChangeListener the reverseAnchorChangeListener to set
	 */
	public void setReverseAnchorChangeListener(
			AnchorChangeListener reverseAnchorChangeListener) {
		table.setAnchorChangeNotifier(reverseAnchorChangeListener);
	}
	
	/**
	 * Returns true if the user can perform any action on the list page. 
	 * 
	 * @return
	 */
	public boolean hasActions() {
		return this.actionsListBox.getItemCount() > 0;
	}

	public void addResizableContainer(ResizableContainer resizableContainer2) {
		this.mainContainer.add(header);
		this.mainContainer.add(messageArea);
		resizableContainer2.addHeightOffsettingWidget(header);
		resizableContainer2.addHeightOffsettingWidget(messageArea);
		resizableContainer2.setOffsetHeight(10);
		this.resizableContainer = resizableContainer2;
		this.mainContainer.add(resizableContainer2);
		
	}
	public MessageArea getMessageArea() {
		return messageArea;
	}

	public void setMessageArea(MessageArea messageArea) {
		this.messageArea = messageArea;
	}

	public void create() {
		mainContainer.clear();
		TitleListCreatePanel createPanel = new TitleListCreatePanel(spec);
		mainContainer.add(createPanel);
	}

	public void setTabSize() {
		if(resizableContainer!= null & resizableContainer.getTabContainer().getTabBar().getTabCount() >1) {
			this.resizableContainer.selectTab("Items");
		}
		
	}

	

	

}
