package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Represents a title list record in the title lists view.
 * 
 * @author spuranik
 * 
 */
public class UiTitleListRecord implements Record<UiTitleListKey> {

	private UiTitleList titleList;
	
	public UiTitleListRecord() { }
		
	public UiTitleListRecord(UiTitleList titleList) {
		super();
		this.titleList = titleList;
	}	
	
	@Override
	public UiTitleListKey getKey() {
		return titleList.getKey();
	}

	/**
	 * @return the titleList
	 */
	public UiTitleList getTitleList() {
		return titleList;
	}

	/**
	 * @param titleList the titleList to set
	 */
	public void setTitleList(UiTitleList titleList) {
		this.titleList = titleList;
	}

}
