package com.ericsson.cms.tools.ui.client;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.tools.ui.client.portlet.ClickThrough;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

public class ToolsComponent extends ComponentBase {
    
        private ToolsConstants constants = GWT.create( ToolsConstants.class );

	@Override
	public List<PortletFactory> listPortlets(NeptuneSecurity security) {
		List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
		if (ClientAuthorizationManager.isAuthorized(Permissions.TOOLS_VIEW)) {
			final Portlet portlet = new ClickThrough();
			portletFactories.add(new GenericPortletFactory(portlet, this));
		}
		return portletFactories;
	}

	@Override
	public <E extends Service> List<E> listServices(Class<E> clazz,
			NeptuneSecurity security) {
		//no menu items
		return new ArrayList<E>();
	}

	@Override
	public List<MenuItemBase> listTabs(NeptuneSecurity security) {
		//no menu items
		return new ArrayList<MenuItemBase>();
	}

	/**
	 * Portlet Factory that maintains the single portlet instance.
	 */
	private static final class GenericPortletFactory implements PortletFactory {
		private Portlet portlet;
		private ToolsComponent toolsComponent;

		public GenericPortletFactory(Portlet portlet, ToolsComponent toolsComponent) {
			this.portlet = portlet;
			this.toolsComponent = toolsComponent;
		}

		@Override
		public Portlet getInstance() {
			return this.portlet;
		}

		@Override
		public void release(Portlet widget) {
			this.portlet = null;
		}

                @Override
                public Component getComponent() {
                    return toolsComponent;
                }
	}

    @Override
    public String getName() {
        return "TOOLS";
    }

    @Override
    public String getDisplayName() {
        return constants.componentDisplayName();
    }
}