package com.ericsson.cms.tools.ui.client.portlet;

import java.util.List;

import com.ericsson.cms.tools.ui.client.Link;
import com.ericsson.cms.tools.ui.client.ToolsConstants;
import com.ericsson.cms.tools.ui.client.UiToolsLinkFetcher;
import com.ericsson.cms.tools.ui.client.UiToolsLinkFetcherAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

public class ClickThrough extends Portlet {

	private ScrollPanel scrollPanel = new ScrollPanel();
	private VerticalPanel panel = new VerticalPanel();
	private ToolsConstants constants = GWT.create(ToolsConstants.class);
	
	private static String RECORDING_PERMISSION_VIEW = "RecordingManagement_View";

	String spec;

	public ClickThrough() {
	        super("CLICK_THROUGH");
		scrollPanel.setHeight("150px");
		panel.setWidth("100%");
		scrollPanel.setAlwaysShowScrollBars(false);
		setTitle(constants.portletTitle());
		setDisplayName(constants.portletTitle());
		scrollPanel.setWidget(panel);
		add(scrollPanel);
		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}
	
	private void load() {
		UiToolsLinkFetcherAsync linkService = GWT.create(UiToolsLinkFetcher.class);
		linkService.getLinks(new NeptuneAsyncCallback<List<Link>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				panel.clear();
			}

			@Override
			public void onNeptuneSuccess(List<Link> result) {
				panel.clear();
				if(result.size() == 0) {
					ClickThrough.this.collapse();
				} else {
					ClickThrough.this.expand();
					for(Link l : result) {
						Anchor a = null;
						//FixMe: ideally should change schema to explicitly specify which link
						// is internal. dont wont to worry about upgrade, so go with this hack
							
						if(l.getHref().startsWith("/portal/#Recording") && 
								ClientAuthorizationManager.isAuthorized(RECORDING_PERMISSION_VIEW)){
							 a = new Anchor(l.getDisplayName(), l.getHref());
							 panel.add(a);
							 panel.setCellHorizontalAlignment(a,
										VerticalPanel.ALIGN_LEFT);
						}
						else if (!l.getHref().startsWith("/portal")){ 
							a = new Anchor(l.getDisplayName(), l.getHref(),
								l.getDisplayName()); 
							panel.add(a);
							panel.setCellHorizontalAlignment(a,
									VerticalPanel.ALIGN_LEFT);
						}
						
					}
				}
				update();
			}
			
		});
	}
	
	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler,
			DocumentDetachHandler {
		@Override
		public void onAttach(DocumentAttachEvent event) {
			load();
		}

		@Override
		public void onDetach(DocumentDetachEvent event) {
			
		}
	}

}
