package com.ericsson.cms.ui.tstv.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemProxy;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyViewWidgetFactory;

/**
 * This class provides all the TSTV RCS menu items under the CMS neptune
 * framework
 * 
 * @author Venkat Bollimuntha
 * 
 */
public class TSTVRCSComponent extends ComponentBase {
	
	private final TSTVRCSComponentConstants constants;

	public TSTVRCSComponent() {
		this.constants = GWT.create(TSTVRCSComponentConstants.class);
	}

	@Override
	public List<PortletFactory> listPortlets(NeptuneSecurity security) {
		List<PortletFactory> factories = new ArrayList<PortletFactory>();
		return factories;
	}

	@Override
	public List<MenuItemBase> listTabs(NeptuneSecurity security) {
		List<MenuItemBase> menuItems = new ArrayList<MenuItemBase>();

		menuItems.add(buildTSTVRCSMenu());
		
		menuItems.add(getRulesMenu());
		
		menuItems.add(getContractMenu());
		
		menuItems.add(getReportsMenu());
		
		menuItems.add(getSchedulingMenu());
		
		return menuItems;
	}
	
	private MenuItemBase getRulesMenu() {
		List<MenuItemBase> menuItems = new ArrayList<MenuItemBase>();
		if (ClientAuthorizationManager
				.isAuthorized(Permissions.RECORDINGMANAGEMENT_VIEW)){
			
				menuItems.add(
						buildFrameMenuItem("Recording Rules",
								constants.menuItemRecordingRules(),
								"/RCS/getRecordingRulesList.do"));
		}
		return new MenuItemProxy(constants.rulesMenuGroupName(), menuItems);
	}
	
	private MenuItemBase getContractMenu() {
		List<MenuItemBase> submenuItems = new ArrayList<MenuItemBase>();
		List<MenuItemBase> menuItems = new ArrayList<MenuItemBase>();

		GroupMenuItem group = new GroupMenuItem("Recording Rights",
				constants.menuItemRightsManagement(), submenuItems);
		menuItems.add(group);

		if (ClientAuthorizationManager.isAuthorized(Permissions.RIGHTSMANAGEMENT_VIEW)) {
			submenuItems.add(
					buildFrameMenuItem("Copyright Holders",
							constants.menuItemCopyrightHolders(),
							"/RCS/listCopyrightHolders.do"));
			submenuItems.add(
					buildFrameMenuItem("Contracts",
							constants.menuItemContracts(),
							"/RCS/listContracts.do"));
			submenuItems.add(
					buildFrameMenuItem("Rights", constants.menuItemRights(),
							"/RCS/searchRights.do"));
		}

		return new MenuItemProxy(constants.contractsGroupName(), menuItems);
	}
	
	private MenuItemBase getReportsMenu(){
		List<MenuItemBase> menuItems = new ArrayList<MenuItemBase>();
		if (ClientAuthorizationManager.isAuthorized(Permissions.REPORTING_VIEW)) {
			menuItems.add(
					buildFrameMenuItem("Events", constants.menuItemEvents(),
							"/RCS/showAllEvents.do"));
		}
		
		return new MenuItemProxy(constants.reportGroupName(), menuItems);
	}
	
	private MenuItemBase getSchedulingMenu(){
		List<MenuItemBase> menuItems = new ArrayList<MenuItemBase>();
		
		if (ClientAuthorizationManager
				.isAuthorized(Permissions.RECORDINGMANAGEMENT_VIEW)) {
			menuItems.add(
					buildFrameMenuItem("Program Guide",
							constants.menuItemProgramGuide(),
							"/RCS/programguide.do"));
			if (ClientAuthorizationManager
					.isAuthorized(Permissions.RECORDINGMANAGEMENT_APPROVE)) {
				menuItems.add(
						buildFrameMenuItem("Approve Recordings",
								constants.menuItemApproveRecordings(),
								"/RCS/showApproveRecording.do"));
			}
			menuItems.add(
					buildFrameMenuItem("Manage Recordings",
							constants.menuItemManageRecordings(),
							"/RCS/manageRecording.do"));
		}
		
		return new MenuItemProxy(constants.schedulingGroupName(),menuItems);
	}
	
	private MenuItemBase buildTSTVRCSMenu() {
		/* Always create the group menu item */
		GroupMenuItem menu = new GroupMenuItem("Recording", constants.componentDisplayName(),
				new ArrayList<MenuItemBase>());
		
		if (ClientAuthorizationManager.isAuthorized(Permissions.RIGHTSMANAGEMENT_VIEW) == true
				|| ClientAuthorizationManager.isAuthorized(Permissions.RECORDINGMANAGEMENT_VIEW) == true
				|| ClientAuthorizationManager.isAuthorized(Permissions.RECORDINGMANAGEMENT_APPROVE) == true
				|| ClientAuthorizationManager
						.isAuthorized(Permissions.CONFIGURATIONMANAGEMENT_VIEW) == true
				|| ClientAuthorizationManager.isAuthorized(Permissions.REPORTING_VIEW) == true) {
			menu.getSubPanels().add(buildFrameMenuItem("Home", constants.menuItemHome(),
						"/RCS/home.do"));
				
			if (ClientAuthorizationManager.isAuthorized(Permissions.CONFIGURATIONMANAGEMENT_VIEW)) {
				GroupMenuItem adminMenu = new GroupMenuItem("Configuration",
				constants.menuItemConfiguration(), new ArrayList<MenuItemBase>());
		
				adminMenu.getSubPanels().add(
						buildFrameMenuItem("System", constants.menuItemSystem(),
								"/RCS/showRcsConfig.do"));
		
				if (ClientAuthorizationManager.isAuthorized(Permissions.USERMANAGEMENT_VIEW)) {
					adminMenu.getSubPanels().add(
							buildFrameMenuItem("AssignRM", constants.menuItemAssignRM(),
									"/RCS/listUsers.do"));
				}
		
				menu.getSubPanels().add(adminMenu);
			}
		}

		return menu;
	}

	/*
	 * Build menu item for a frame widget
	 */
	private WidgetMenuItem buildFrameMenuItem(String name, String displayName,
			String url) {
		TSTVRCSFrame frame = new TSTVRCSFrame(url);
		LazyViewWidgetFactory factory = new LazyViewWidgetFactory(frame);
		WidgetMenuItem menuItem = new WidgetMenuItem(name, displayName,
				factory, factory.getAnchorChangeListener());
		factory.setAnchorChangeNotifier(menuItem
				.getReverseAnchorChangeListener());
		return menuItem;
	}

	@Override
	public <E extends Service> List<E> listServices(Class<E> clazz,
			NeptuneSecurity security) {
		return null;
	}

	@Override
	public String getName() {
		return "TSTVRCSComponent";
	}

	@Override
	public String getDisplayName() {
		return "TSTV RCS Component";
	}
}
