
package com.ericsson.cms.ui.tstv.client;

import java.util.Map;

import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;

/**
 * A Frame widget that is a lazy view
 * 
 * @author Venkat Bollimuntha
 */
public class TSTVRCSFrame extends LazyView {

	private final String defaultURL;
	private Frame widget = null;

	public TSTVRCSFrame(String defaultURL) {
		this.defaultURL = defaultURL;
	}

	@Override
	public String getAnchor() {
		String url = (widget != null) ? widget.getUrl() : null;
		return (url != null && !url.isEmpty()) ? "URL=" + URL.encode(url) : "";
	}

	@Override
	protected void setWidgetAnchor(String anchor) {
		String url = null;
		if (anchor != null && !anchor.isEmpty()) {
			AnchorTokenizer tokenizer = new AnchorTokenizer();
			Map<String, String> tokens = tokenizer.parseAnchor(anchor);
			url = tokens.get("URL");
		}

		if (url == null || url.isEmpty()) {
			url = this.defaultURL;
		} else {
			url = URL.decode(url);
		}

		this.widget.setUrl(url);
	}

	@Override
	protected Widget createWidget() {
		this.widget = new FrameWidget(){
			public void onBrowserEvent(Event event) {
			    super.onBrowserEvent(event);
			    NeptuneApplication.getApplication().hideMenu();
			  }
			};
		widget.sinkEvents(Event.ONMOUSEOVER);
		widget.getElement().setAttribute("frameBorder", "0");
		return this.widget;
	}
}
