/**
 * Permission.java
 * Created Sep 13, 2010
 */
package com.tandbergtv.cms.ui.workflow.client;

/**
 * List of permission names
 * 
 * @author Sahil Verma
 */
public enum Permission {

	HOME("Home_Dashboard"),
	WORK_ORDERS_VIEW("WorkOrderManagement_View"),
	WORK_ORDERS_MODIFY("WorkOrderManagement_Modify"),
	RESOURCES_VIEW("ResourceManagement_View"),
	PLUGINS_VIEW("Plugins_View"),
	TASKS_PERFORM("UserTasks_PerformTask"),
	PERFORM_OTHERS_TASKS("UserTasks_PerformOthersTasks"),
	MONITORING_VIEW("Monitoring_View"),
	TASKS_ASSIGN("UserTasks_AssignTask"),
	TASKS_ASSIGN_OTHERS("UserTasks_AssignTaskToOthers");
	
	private String permission;

	private Permission() {
	}

	/**
	 * @param name
	 */
	private Permission(String permission) {
		this.permission = permission;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return permission;
	}
}
