package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.user.client.rpc.IsSerializable;

public class Resource implements IsSerializable {
	public enum State implements IsSerializable {
		INITIALIZING,
		ONLINE,
		OFFLINE,
		INITIALIZATION_ERROR,
		HEARTBEAT_ERROR,
		ERROR,
		INACTIVE,
		INVALID;
	}
	
	private String name;
	private State state;
	private boolean currentlyUsed;
	private long id;
	
	public Resource() {}
	
	public Resource(long id, String name) {
		this.id = id;
		setName(name);
	}
	
	public long getId() {
		return id;
	}

	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public State getState() {
		return state;
	}
	
	public void setState(State state) {
		this.state = state;
	}

	public boolean isCurrentlyUsed() {
		return currentlyUsed;
	}

	public void setCurrentlyUsed(boolean currentlyUsed) {
		this.currentlyUsed = currentlyUsed;
	}
}
