package com.tandbergtv.cms.ui.workflow.client;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

/**
 * CSS:
 * portlet-resGrpQList-text - text
 * 
 * @author rprakash
 */
public class ResourceGroupQueueListPortlet extends Portlet {
	private FlexTableContainer table;
	private IListResourceGroupQueuesAsync service;
	private PortletConstants constants;
	private Timer refreshTimer;
	private int refreshPeriod;

	public ResourceGroupQueueListPortlet(int refreshTimeMillis) {
	        super("RESOURCE_GROUP_QUEUE_LIST");
		this.refreshPeriod = refreshTimeMillis;

		service = GWT.create(IListResourceGroupQueues.class);
		constants = GWT.create(PortletConstants.class);

		setTitle(constants.queueTitle());
		setDisplayName(constants.queueTitle());

		table = new FlexTableContainer();
		table.setStyleName("portlet-resGrpQList-table");
		add(table);

		this.refreshTimer = new Timer() {
			public void run() {
				reload();
			};
		};

		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}

	private void reload() {
		service.getResourceGroupQueues(new NeptuneAsyncCallback<List<Queue>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}

			@Override
			public void onNeptuneSuccess(List<Queue> queues) {
				table.clear();

				Collections.sort(queues, new Comparator<Queue>() {
					@Override
					public int compare(Queue o1, Queue o2) {
						return o1.getName().compareTo(o2.getName());
					}
				});

				int rowCount = 0;
				for (Queue q : queues) {
					table.getCellFormatter().setStyleName(rowCount, 0, "portlet-resGrpQList-name-cell");
					HyperlinkWidget name = new HyperlinkWidget(q.getName(),
					        "Workflow.Resources.Queue?id=" + q.getId());
					name.setStyleName("portlet-resGrpQList-name-link");
					table.setWidget(rowCount, 0, name);

					table.getCellFormatter().setStyleName(rowCount, 1, "portlet-resGrpQList-count-cell");
					LabelWidget count = new LabelWidget(String.valueOf(q.getNumItemsInQueue()));
					count.setStyleName("portlet-resGrpQList-count-label");
					table.setWidget(rowCount, 1, count);

					rowCount++;
				}
				update();
			}
		});
	}

	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler, DocumentDetachHandler {
		@Override
		public void onAttach(DocumentAttachEvent event) {
			refreshTimer.scheduleRepeating(refreshPeriod);
			reload();
		}

		@Override
		public void onDetach(DocumentDetachEvent event) {
			refreshTimer.cancel();
		}
	}
}
