package com.tandbergtv.cms.ui.workflow.client;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

/**
 * CSS:
 * portlet-resourceList-table - container table
 * portlet-resourceList-statusImgCol - status image column
 * portlet-resourceList-nameCol - name column
 * portlet-resourceList-currUsedImgCol - currently used image column
 * 
 * @author rprakash
 */
public class ResourceListPortlet extends Portlet {
	private FlexTableContainer table;
	private IListResourcesAsync service;
	private PortletConstants constants;
	private Timer refreshTimer;
	private int refreshPeriod;

	public ResourceListPortlet(int refreshTimeMillis) {
	        super("RESOURCE_LIST");
		service = GWT.create(IListResources.class);
		constants = GWT.create(PortletConstants.class);
		refreshPeriod = refreshTimeMillis;

		setTitle(constants.resTitle());
		setDisplayName(constants.resTitle());

		table = new FlexTableContainer();
		table.setStyleName("portlet-resourceList-table");
		add(table);

		this.refreshTimer = new Timer() {
			@Override
			public void run() {
				reload();
			}
		};

		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}

	private void reload() {
		service.getResources(new NeptuneAsyncCallback<List<Resource>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}

			@Override
			public void onNeptuneSuccess(List<Resource> resources) {
				table.clear();
				int rowCount = 0;

				Collections.sort(resources, new Comparator<Resource>() {
					@Override
					public int compare(Resource r1, Resource r2) {
						return r1.getName().compareTo(r2.getName());
					}
				});

				for (Resource resource : resources) {
					table.setWidget(rowCount, 0, getImage(resource.getState()));
					table.getCellFormatter().setStyleName(rowCount, 0, "portlet-resourceList-statusImgCol");

					HyperlinkWidget link =
						new HyperlinkWidget(resource.getName(), "Workflow.Resources.Modify?id=" + resource.getId());
					
					table.setWidget(rowCount, 1, link);
					
					table.getCellFormatter().setStyleName(rowCount, 1, "portlet-resourceList-nameCol");

					if (resource.isCurrentlyUsed()) {
						ImageWidget image = new ImageWidget("images/icon_res_currUsed.png");
						image.setTitle(constants.resCurrentlyUsed());
						table.setWidget(rowCount, 2, image);
						table.getCellFormatter().setStyleName(rowCount, 2, "portlet-resourceList-currUsedImgCol");
					}

					rowCount++;
				}
				
				update();
			}
		});
	}

	private ImageWidget getImage(Resource.State state) {
		ImageWidget image = new ImageWidget("images/icon_circ_" + state.name() + ".png");
		image.setTitle(constants.getString("res" + state.name()));
		return image;
	}

	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler, DocumentDetachHandler {
        @Override
        public void onAttach(DocumentAttachEvent event) {
    		refreshTimer.scheduleRepeating(refreshPeriod);
    		reload();
        }

        @Override
        public void onDetach(DocumentDetachEvent event) {
    		refreshTimer.cancel();
        }
	}
}
