package com.tandbergtv.cms.ui.workflow.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * This class represents a table in the UI layer.
 * 
 * 
 */
public class UiTable implements IsSerializable {

	private String defaultSortingOrder;
	private String defaultSortColumnName;
	private List<UiColumn> columns;

	public UiTable() {
		this.columns = new ArrayList<UiColumn>();
	}

	public void addColumn(UiColumn col) {
		this.columns.add(col);
	}

	/**
	 * @return the defaultSortingOrder
	 */
	public String getDefaultSortingOrder() {
		return defaultSortingOrder;
	}

	/**
	 * @param defaultSortingOrder
	 *            the defaultSortingOrder to set
	 */
	public void setDefaultSortingOrder(String defaultSortingOrder) {
		this.defaultSortingOrder = defaultSortingOrder;
	}

	/**
	 * @return the defaultSortColumnName
	 */
	public String getDefaultSortColumnName() {
		return defaultSortColumnName;
	}

	/**
	 * @param defaultSortColumnName
	 *            the defaultSortColumnName to set
	 */
	public void setDefaultSortColumnName(String defaultSortColumnName) {
		this.defaultSortColumnName = defaultSortColumnName;
	}

	/**
	 * @return the columns
	 */
	public List<UiColumn> getColumns() {
		return columns;
	}

	/**
	 * @param columns
	 *            the columns to set
	 */
	public void setColumns(List<UiColumn> columns) {
		this.columns = columns;
	}

}
