package com.tandbergtv.cms.ui.workflow.client;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UserTask implements IsSerializable {
	
	public static final long INVALID_TASKINSTANCE_ID = -1;
	
	private String name;
	private String workOrderTemplate;
	private long workOrderID;
	private long taskInstanceId = INVALID_TASKINSTANCE_ID;
	private String resourceGroup;
	private String assignedDateTime;
	
	private Map<String,Object> processVariables = new HashMap<String,Object>();
	private Map<String,Object> taskProperties = new HashMap<String,Object>();

	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
		taskProperties.put("name", name);
	}
	
	public String getWorkOrderTemplate() {
		return workOrderTemplate;
	}

	public void setWorkOrderTemplate(String workOrderTemplate) {
		this.workOrderTemplate = workOrderTemplate;
		taskProperties.put("workOrderTemplate", workOrderTemplate);
	}

	public long getWorkOrderID() {
		return workOrderID;
	}

	public void setWorkOrderID(long workOrderID) {
		this.workOrderID = workOrderID;
		taskProperties.put("workOrderID", workOrderID);
	}

	public String getResourceGroup() {
		return resourceGroup;
	}

	public void setResourceGroup(String resourceGroup) {
		this.resourceGroup = resourceGroup;
		taskProperties.put("resourceGroup", resourceGroup);
	}

	public long getTaskInstanceId() {
		return taskInstanceId;
	}

	public void setTaskInstanceId(long taskInstanceId) {
		this.taskInstanceId = taskInstanceId;
		taskProperties.put("taskInstanceId", taskInstanceId);
	}

	public boolean hasEnded() {
		return taskInstanceId == INVALID_TASKINSTANCE_ID;
	}

	public void setAssignedDateTime(String assignedDateTime) {
		this.assignedDateTime = assignedDateTime;
		taskProperties.put("assignedDateTime", assignedDateTime);
	}

	public String getAssignedDateTime() {
		return assignedDateTime;
	}
	
	public void addProcessVariable(String varName, Object varValue) {
		this.processVariables.put(varName, varValue);
	}
	
	public Object getProcessVariable(String varName) {
		return processVariables.get(varName);
	}
	
	public Object getTaskProperty(String propertyName) {
		return taskProperties.get(propertyName);
	}

}
