package com.tandbergtv.cms.ui.workflow.client;

import java.util.Map;
import java.util.TreeMap;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

/**
 * CSS:
 * portlet-woStatus-table - container table
 * portlet-woStatus-imgCol - image column
 * portlet-woStatus-nameCol - status name column
 * portlet-woStatus-countCol - workorder count column
 * 
 * @author rprakash
 */
public class WOStatusPortlet extends Portlet {
	private FlexTableContainer table;
	private IWOStatusAsync service;
	private PortletConstants constants;
	private Timer refreshTimer;
	private int refreshPeriod;
	
	public WOStatusPortlet(int refreshTimeMillis) {
	        super("WO_STATUS");
		this.refreshPeriod = refreshTimeMillis;
		
		service = GWT.create(IWOStatus.class);
		constants = GWT.create(PortletConstants.class);

		setTitle(constants.woTitle());
		setDisplayName(constants.woTitle());
		
		table = new FlexTableContainer();
		table.setStyleName("portlet-woStatus-table");
		add(table);
		
		this.refreshTimer = new Timer() {
			@Override
			public void run() {
				reload();
			}
		};

		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}

	private void reload() {
		service.getStatus(new NeptuneAsyncCallback<Map<WOState,Integer>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}

			@Override
			public void onNeptuneSuccess(Map<WOState, Integer> result) {
				table.clear();
				int rowCount = 0;
				
				Map<WOState, Integer> sorted = new TreeMap<WOState, Integer>(result);
				
				for(Map.Entry<WOState, Integer> statusEntry : sorted.entrySet()) {
					table.setWidget(rowCount, 0, getImage(statusEntry.getKey()));
					table.getCellFormatter().setStyleName(rowCount, 0, "portlet-woStatus-imgCol");

					table.setWidget(rowCount, 1,
							new HyperlinkWidget(getLocalizedStateName(statusEntry.getKey()),
									"Workflow.Work Orders.Search.Status=" + statusEntry.getKey()));
					table.getCellFormatter().setStyleName(rowCount, 1, "portlet-woStatus-nameCol");
					
					table.setWidget(rowCount, 2, new LabelWidget(String.valueOf(statusEntry.getValue())));
					table.getCellFormatter().setStyleName(rowCount, 2, "portlet-woStatus-countCol");
					
					rowCount++;
				}
				
				update();
			}});
	}
	
	private ImageWidget getImage(WOState state) {
		ImageWidget image = new ImageWidget("images/icon_rect_" + state.name() + ".gif");
		image.setTitle(getLocalizedStateName(state));
		return image;
	}
	
	private String getLocalizedStateName(WOState state) {
		return constants.getString("wo" + state.name());
	}

	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler, DocumentDetachHandler {
		@Override
		public void onAttach(DocumentAttachEvent event) {
			refreshTimer.scheduleRepeating(refreshPeriod);
			reload();
		}

		@Override
		public void onDetach(DocumentDetachEvent event) {
			refreshTimer.cancel();
		}
	}
}
