/**
 * 
 */
package com.tandbergtv.cms.ui.workflow.client.model;

import java.io.Serializable;

/**
 * Represents an activity that uses a resource
 * 
 * @author Sahil Verma
 */
public class ActiveResource implements Serializable {
	
	private static final long serialVersionUID = 4256745553926205991L;
	
	private String template;
	
	private long pid;
	
	private String node;
	
	private String percentComplete;
	
	private String resource;
	
	private long id;
	
	private String titleDisplayName;
	
	private long titleId;

	/**
	 * Required for GWT serialization
	 */
	public ActiveResource() {
		super();
	}

	public ActiveResource(long id, String resource, long pid, String template, String node, String percent) {
		super();
		this.id = id;
		this.resource = resource;
		this.pid = pid;
		this.template = template;
		this.node = node;
		this.percentComplete = percent;
	}

	public ActiveResource(long id, String resource, long pid, String template, String node, String percent, 
		long titleId, String title) {
		super();
		this.id = id;
		this.resource = resource;
		this.pid = pid;
		this.template = template;
		this.node = node;
		this.percentComplete = percent;
		this.titleId = titleId;
		this.titleDisplayName = title;
	}
	
	public String getResource() {
		return resource;
	}

	public long getId() {
		return id;
	}

	public long getPid() {
		return pid;
	}

	public String getNode() {
		return node;
	}

	public String getPercentComplete() {
		return percentComplete;
	}

	public String getTemplate() {
		return template;
	}

	public String getTitleDisplayName() {
		return titleDisplayName;
	}

	public long getTitleId() {
		return titleId;
	}
}
