/**
 * ActiveResources.java
 * Created Sep 14, 2010
 */
package com.tandbergtv.cms.ui.workflow.client.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * A simple (active resources, total) tuple
 * 
 * @author Sahil Verma
 */
public class ActiveResources implements Serializable {

	private static final long serialVersionUID = 3298464928518832826L;

	private List<ActiveResource> resources;
	
	private int total;

	/**
	 * APPEASE THE SERIALIZATION GODDESS
	 */
	public ActiveResources() {
		super();
	}

	/**
	 * @param resources
	 * @param total
	 */
	public ActiveResources(int total) {
		super();
		this.resources = new ArrayList<ActiveResource>();
		this.total = total;
	}

	/**
	 * Gets the list of all {@link ActiveResource}s
	 * 
	 * @return the resources
	 */
	public List<ActiveResource> getResources() {
		return resources;
	}

	/**
	 * Adds the specified {@link ActiveResource}
	 * 
	 * @param activeresource
	 */
	public void addActiveResource(ActiveResource activeresource) {
		resources.add(activeresource);
	}
	
	/**
	 * Sets the list of {@link ActiveResource}s
	 * @param resources
	 */
	public void setResources(List<ActiveResource> resources) {
		this.resources = resources;
	}

	/**
	 * @return the total
	 */
	public int getTotal() {
		return total;
	}
}
