/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CharFunction
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__char";
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        StringBuilder sb = new StringBuilder(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            String numberString = ((CompoundVariable)this.values[i]).execute().trim();
            try {
                long value = Long.decode(numberString);
                char ch = (char)value;
                sb.append(ch);
                continue;
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse " + numberString + " : " + e);
            }
        }
        return sb.toString();
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkMinParameterCount(parameters, 1);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"char_value"));
    }
}

