/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.gui.HTTPArgumentsPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;

public class UrlConfigGui
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 240L;
    private static final int TAB_PARAMETERS = 0;
    private static final int TAB_RAW_BODY = 1;
    private static final Font FONT_SMALL = new Font("SansSerif", 0, 12);
    private HTTPArgumentsPanel argsPanel;
    private JTextField domain;
    private JTextField port;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField proxyUser;
    private JPasswordField proxyPass;
    private JTextField connectTimeOut;
    private JTextField responseTimeOut;
    private JTextField protocol;
    private JTextField contentEncoding;
    private JTextField path;
    private JCheckBox followRedirects;
    private JCheckBox autoRedirects;
    private JCheckBox useKeepAlive;
    private JCheckBox useMultipartForPost;
    private JCheckBox useBrowserCompatibleMultipartMode;
    private JLabeledChoice method;
    private JLabeledChoice httpImplementation;
    private final boolean notConfigOnly;
    private final boolean showImplementation;
    private JSyntaxTextArea postBodyContent;
    private ValidationTabbedPane postContentTabbedPane;
    private boolean showRawBodyPane;

    public UrlConfigGui() {
        this(true);
    }

    public UrlConfigGui(boolean showSamplerFields) {
        this(showSamplerFields, true, true);
    }

    public UrlConfigGui(boolean showSamplerFields, boolean showImplementation, boolean showRawBodyPane) {
        this.notConfigOnly = showSamplerFields;
        this.showImplementation = showImplementation;
        this.showRawBodyPane = showRawBodyPane;
        this.init();
    }

    public void clear() {
        this.domain.setText("");
        if (this.notConfigOnly) {
            this.followRedirects.setSelected(true);
            this.autoRedirects.setSelected(false);
            this.method.setText("GET");
            this.useKeepAlive.setSelected(true);
            this.useMultipartForPost.setSelected(false);
            this.useBrowserCompatibleMultipartMode.setSelected(false);
        }
        if (this.showImplementation) {
            this.httpImplementation.setText("");
        }
        this.path.setText("");
        this.port.setText("");
        this.proxyHost.setText("");
        this.proxyPort.setText("");
        this.proxyUser.setText("");
        this.proxyPass.setText("");
        this.connectTimeOut.setText("");
        this.responseTimeOut.setText("");
        this.protocol.setText("");
        this.contentEncoding.setText("");
        this.argsPanel.clear();
        if (this.showRawBodyPane) {
            this.postBodyContent.setInitialText("");
        }
        this.postContentTabbedPane.setSelectedIndex(0, false);
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        element.setName(this.getName());
        element.setProperty("TestElement.gui_class", this.getClass().getName());
        element.setProperty("TestElement.test_class", element.getClass().getName());
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        Arguments args;
        boolean useRaw;
        boolean bl = useRaw = this.postContentTabbedPane.getSelectedIndex() == 1;
        if (useRaw) {
            args = new Arguments();
            String text = this.postBodyContent.getText();
            HTTPArgument arg = new HTTPArgument("", text.replaceAll("\n", "\r\n"), false);
            arg.setAlwaysEncoded(false);
            args.addArgument((Argument)arg);
        } else {
            args = (Arguments)this.argsPanel.createTestElement();
            HTTPArgument.convertArgumentsToHTTP(args);
        }
        element.setProperty("HTTPSampler.postBodyRaw", useRaw, false);
        element.setProperty((JMeterProperty)new TestElementProperty("HTTPsampler.Arguments", (TestElement)args));
        element.setProperty("HTTPSampler.domain", this.domain.getText());
        element.setProperty("HTTPSampler.port", this.port.getText());
        element.setProperty("HTTPSampler.proxyHost", this.proxyHost.getText(), "");
        element.setProperty("HTTPSampler.proxyPort", this.proxyPort.getText(), "");
        element.setProperty("HTTPSampler.proxyUser", this.proxyUser.getText(), "");
        element.setProperty("HTTPSampler.proxyPass", String.valueOf(this.proxyPass.getPassword()), "");
        element.setProperty("HTTPSampler.connect_timeout", this.connectTimeOut.getText());
        element.setProperty("HTTPSampler.response_timeout", this.responseTimeOut.getText());
        element.setProperty("HTTPSampler.protocol", this.protocol.getText());
        element.setProperty("HTTPSampler.contentEncoding", this.contentEncoding.getText());
        element.setProperty("HTTPSampler.path", this.path.getText());
        if (this.notConfigOnly) {
            element.setProperty("HTTPSampler.method", this.method.getText());
            element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.follow_redirects", this.followRedirects.isSelected()));
            element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.auto_redirects", this.autoRedirects.isSelected()));
            element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.use_keepalive", this.useKeepAlive.isSelected()));
            element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.DO_MULTIPART_POST", this.useMultipartForPost.isSelected()));
            element.setProperty("HTTPSampler.BROWSER_COMPATIBLE_MULTIPART", this.useBrowserCompatibleMultipartMode.isSelected(), false);
        }
        if (this.showImplementation) {
            element.setProperty("HTTPSampler.implementation", this.httpImplementation.getText(), "");
        }
    }

    private static final String computePostBody(Arguments arguments) {
        return UrlConfigGui.computePostBody(arguments, false);
    }

    private static final String computePostBody(Arguments arguments, boolean crlfToLF) {
        StringBuilder postBody = new StringBuilder();
        PropertyIterator args = arguments.iterator();
        while (args.hasNext()) {
            HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
            String value = arg.getValue();
            if (crlfToLF) {
                value = value.replaceAll("\r\n", "\n");
            }
            postBody.append(value);
        }
        return postBody.toString();
    }

    public void configure(TestElement el) {
        this.setName(el.getName());
        Arguments arguments = (Arguments)el.getProperty("HTTPsampler.Arguments").getObjectValue();
        boolean useRaw = el.getPropertyAsBoolean("HTTPSampler.postBodyRaw", false);
        if (useRaw) {
            String postBody = UrlConfigGui.computePostBody(arguments, true);
            this.postBodyContent.setInitialText(postBody);
            this.postBodyContent.setCaretPosition(0);
            this.postContentTabbedPane.setSelectedIndex(1, false);
        } else {
            this.argsPanel.configure((TestElement)arguments);
            this.postContentTabbedPane.setSelectedIndex(0, false);
        }
        this.domain.setText(el.getPropertyAsString("HTTPSampler.domain"));
        String portString = el.getPropertyAsString("HTTPSampler.port");
        if (portString.equals("0")) {
            this.port.setText("");
        } else {
            this.port.setText(portString);
        }
        this.proxyHost.setText(el.getPropertyAsString("HTTPSampler.proxyHost"));
        this.proxyPort.setText(el.getPropertyAsString("HTTPSampler.proxyPort"));
        this.proxyUser.setText(el.getPropertyAsString("HTTPSampler.proxyUser"));
        this.proxyPass.setText(el.getPropertyAsString("HTTPSampler.proxyPass"));
        this.connectTimeOut.setText(el.getPropertyAsString("HTTPSampler.connect_timeout"));
        this.responseTimeOut.setText(el.getPropertyAsString("HTTPSampler.response_timeout"));
        this.protocol.setText(el.getPropertyAsString("HTTPSampler.protocol"));
        this.contentEncoding.setText(el.getPropertyAsString("HTTPSampler.contentEncoding"));
        this.path.setText(el.getPropertyAsString("HTTPSampler.path"));
        if (this.notConfigOnly) {
            this.method.setText(el.getPropertyAsString("HTTPSampler.method"));
            this.followRedirects.setSelected(el.getPropertyAsBoolean("HTTPSampler.follow_redirects"));
            this.autoRedirects.setSelected(el.getPropertyAsBoolean("HTTPSampler.auto_redirects"));
            this.useKeepAlive.setSelected(el.getPropertyAsBoolean("HTTPSampler.use_keepalive"));
            this.useMultipartForPost.setSelected(el.getPropertyAsBoolean("HTTPSampler.DO_MULTIPART_POST"));
            this.useBrowserCompatibleMultipartMode.setSelected(el.getPropertyAsBoolean("HTTPSampler.BROWSER_COMPATIBLE_MULTIPART", false));
        }
        if (this.showImplementation) {
            this.httpImplementation.setText(el.getPropertyAsString("HTTPSampler.implementation"));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel webRequestPanel = new JPanel();
        webRequestPanel.setLayout(new BorderLayout());
        webRequestPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_request")));
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        northPanel.add(this.getProtocolAndMethodPanel());
        northPanel.add(this.getPathPanel());
        webRequestPanel.add((Component)northPanel, "North");
        webRequestPanel.add((Component)this.getParameterPanel(), "Center");
        this.add((Component)this.getWebServerTimeoutPanel(), "North");
        this.add((Component)webRequestPanel, "Center");
        this.add((Component)this.getProxyServerPanel(), "South");
    }

    protected final JPanel getWebServerTimeoutPanel() {
        HorizontalPanel webServerPanel = new HorizontalPanel();
        webServerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_server")));
        JPanel domainPanel = this.getDomainPanel();
        JPanel portPanel = this.getPortPanel();
        webServerPanel.add((Component)domainPanel, "Center");
        webServerPanel.add((Component)portPanel, "East");
        HorizontalPanel timeOut = new HorizontalPanel();
        timeOut.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_server_timeout_title")));
        JPanel connPanel = this.getConnectTimeOutPanel();
        JPanel reqPanel = this.getResponseTimeOutPanel();
        timeOut.add(connPanel);
        timeOut.add(reqPanel);
        VerticalPanel webServerTimeoutPanel = new VerticalPanel();
        webServerTimeoutPanel.add((Component)webServerPanel, "Center");
        webServerTimeoutPanel.add((Component)timeOut, "East");
        VerticalPanel bigPanel = new VerticalPanel();
        bigPanel.add((Component)webServerTimeoutPanel);
        return bigPanel;
    }

    protected final JPanel getProxyServerPanel() {
        HorizontalPanel proxyServer = new HorizontalPanel();
        proxyServer.add((Component)this.getProxyHostPanel(), "Center");
        proxyServer.add((Component)this.getProxyPortPanel(), "East");
        HorizontalPanel proxyLogin = new HorizontalPanel();
        proxyLogin.add(this.getProxyUserPanel());
        proxyLogin.add(this.getProxyPassPanel());
        HorizontalPanel proxyServerPanel = new HorizontalPanel();
        proxyServerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_proxy_server_title")));
        proxyServerPanel.add((Component)proxyServer);
        proxyServerPanel.add((Component)proxyLogin);
        return proxyServerPanel;
    }

    private JPanel getPortPanel() {
        this.port = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.port);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.port, "Center");
        return panel;
    }

    private JPanel getProxyPortPanel() {
        this.proxyPort = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.proxyPort);
        label.setFont(FONT_SMALL);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPort, "Center");
        return panel;
    }

    private JPanel getConnectTimeOutPanel() {
        this.connectTimeOut = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_connect"));
        label.setLabelFor(this.connectTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.connectTimeOut, "Center");
        return panel;
    }

    private JPanel getResponseTimeOutPanel() {
        this.responseTimeOut = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_response"));
        label.setLabelFor(this.responseTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.responseTimeOut, "Center");
        return panel;
    }

    private JPanel getDomainPanel() {
        this.domain = new JTextField(20);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_domain"));
        label.setLabelFor(this.domain);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.domain, "Center");
        return panel;
    }

    private JPanel getProxyHostPanel() {
        this.proxyHost = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_domain"));
        label.setLabelFor(this.proxyHost);
        label.setFont(FONT_SMALL);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyHost, "Center");
        return panel;
    }

    private JPanel getProxyUserPanel() {
        this.proxyUser = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"username"));
        label.setLabelFor(this.proxyUser);
        label.setFont(FONT_SMALL);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyUser, "Center");
        return panel;
    }

    private JPanel getProxyPassPanel() {
        this.proxyPass = new JPasswordField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"password"));
        label.setLabelFor(this.proxyPass);
        label.setFont(FONT_SMALL);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPass, "Center");
        return panel;
    }

    protected Component getPathPanel() {
        this.path = new JTextField(15);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"path"));
        label.setLabelFor(this.path);
        if (this.notConfigOnly) {
            this.followRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
            this.followRedirects.setFont(null);
            this.followRedirects.setSelected(true);
            this.followRedirects.addChangeListener(this);
            this.autoRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects_auto"));
            this.autoRedirects.setFont(null);
            this.autoRedirects.addChangeListener(this);
            this.autoRedirects.setSelected(false);
            this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
            this.useKeepAlive.setFont(null);
            this.useKeepAlive.setSelected(true);
            this.useMultipartForPost = new JCheckBox(JMeterUtils.getResString((String)"use_multipart_for_http_post"));
            this.useMultipartForPost.setFont(null);
            this.useMultipartForPost.setSelected(false);
            this.useBrowserCompatibleMultipartMode = new JCheckBox(JMeterUtils.getResString((String)"use_multipart_mode_browser"));
            this.useBrowserCompatibleMultipartMode.setFont(null);
            this.useBrowserCompatibleMultipartMode.setSelected(false);
        }
        HorizontalPanel pathPanel = new HorizontalPanel();
        pathPanel.add(label);
        pathPanel.add(this.path);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add((Component)pathPanel);
        if (this.notConfigOnly) {
            JPanel optionPanel = new JPanel(new FlowLayout(0));
            optionPanel.setFont(FONT_SMALL);
            optionPanel.add(this.autoRedirects);
            optionPanel.add(this.followRedirects);
            optionPanel.add(this.useKeepAlive);
            optionPanel.add(this.useMultipartForPost);
            optionPanel.add(this.useBrowserCompatibleMultipartMode);
            optionPanel.setMinimumSize(optionPanel.getPreferredSize());
            panel.add(optionPanel);
        }
        return panel;
    }

    protected JPanel getProtocolAndMethodPanel() {
        if (this.showImplementation) {
            this.httpImplementation = new JLabeledChoice(JMeterUtils.getResString((String)"http_implementation"), HTTPSamplerFactory.getImplementations());
            this.httpImplementation.addValue("");
        }
        this.protocol = new JTextField(4);
        JLabel protocolLabel = new JLabel(JMeterUtils.getResString((String)"protocol"));
        protocolLabel.setLabelFor(this.protocol);
        this.contentEncoding = new JTextField(10);
        JLabel contentEncodingLabel = new JLabel(JMeterUtils.getResString((String)"content_encoding"));
        contentEncodingLabel.setLabelFor(this.contentEncoding);
        if (this.notConfigOnly) {
            this.method = new JLabeledChoice(JMeterUtils.getResString((String)"method"), HTTPSamplerBase.getValidMethodsAsArray());
        }
        JPanel panel = new JPanel(new FlowLayout(0));
        if (this.showImplementation) {
            panel.add((Component)this.httpImplementation);
        }
        panel.add(protocolLabel);
        panel.add(this.protocol);
        panel.add(Box.createHorizontalStrut(5));
        if (this.notConfigOnly) {
            panel.add((Component)this.method);
        }
        panel.setMinimumSize(panel.getPreferredSize());
        panel.add(Box.createHorizontalStrut(5));
        panel.add(contentEncodingLabel);
        panel.add(this.contentEncoding);
        panel.setMinimumSize(panel.getPreferredSize());
        return panel;
    }

    protected JTabbedPane getParameterPanel() {
        this.postContentTabbedPane = new ValidationTabbedPane();
        this.argsPanel = new HTTPArgumentsPanel();
        this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_as_parameters"), (Component)((Object)this.argsPanel));
        if (this.showRawBodyPane) {
            this.postBodyContent = new JSyntaxTextArea(30, 50);
            this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_body"), (Component)new JTextScrollPane(this.postBodyContent));
        }
        return this.postContentTabbedPane;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.autoRedirects && this.autoRedirects.isSelected()) {
            this.followRedirects.setSelected(false);
        }
        if (e.getSource() == this.followRedirects && this.followRedirects.isSelected()) {
            this.autoRedirects.setSelected(false);
        }
    }

    void convertParametersToRaw() {
        this.postBodyContent.setInitialText(UrlConfigGui.computePostBody((Arguments)this.argsPanel.createTestElement()));
        this.postBodyContent.setCaretPosition(0);
    }

    boolean canConvertParameters() {
        Arguments arguments = (Arguments)this.argsPanel.createTestElement();
        for (int i = 0; i < arguments.getArgumentCount(); ++i) {
            if (StringUtils.isEmpty((CharSequence)arguments.getArgument(i).getName())) continue;
            return false;
        }
        return true;
    }

    boolean noData(int oldSelectedIndex) {
        if (oldSelectedIndex == 1) {
            return StringUtils.isEmpty((CharSequence)this.postBodyContent.getText().trim());
        }
        Arguments element = (Arguments)this.argsPanel.createTestElement();
        return StringUtils.isEmpty((CharSequence)UrlConfigGui.computePostBody(element));
    }

    class ValidationTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 7014311238367882880L;

        ValidationTabbedPane() {
        }

        @Override
        public void setSelectedIndex(int index) {
            this.setSelectedIndex(index, true);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setSelectedIndex(int index, boolean check) {
            int oldSelectedIndex = this.getSelectedIndex();
            if (!check || oldSelectedIndex == -1) {
                super.setSelectedIndex(index);
                return;
            }
            if (index == this.getSelectedIndex()) return;
            if (UrlConfigGui.this.noData(this.getSelectedIndex())) {
                UrlConfigGui.this.argsPanel.clear();
                UrlConfigGui.this.postBodyContent.setInitialText("");
                super.setSelectedIndex(index);
                return;
            }
            if (oldSelectedIndex == 1) {
                if (UrlConfigGui.this.postBodyContent.getText().equals(UrlConfigGui.computePostBody((Arguments)UrlConfigGui.this.argsPanel.createTestElement()).trim())) {
                    super.setSelectedIndex(index);
                    return;
                }
                JOptionPane.showConfirmDialog(this, JMeterUtils.getResString((String)"web_cannot_switch_tab"), JMeterUtils.getResString((String)"warning"), -1, 0);
                return;
            }
            if (UrlConfigGui.this.canConvertParameters()) {
                Object[] options = new Object[]{JMeterUtils.getResString((String)"confirm"), JMeterUtils.getResString((String)"cancel")};
                int n = JOptionPane.showOptionDialog(this, JMeterUtils.getResString((String)"web_parameters_lost_message"), JMeterUtils.getResString((String)"warning"), 1, 3, null, options, options[1]);
                if (n != 0) return;
                UrlConfigGui.this.convertParametersToRaw();
                super.setSelectedIndex(index);
                return;
            }
            JOptionPane.showConfirmDialog(this, JMeterUtils.getResString((String)"web_cannot_convert_parameters_to_raw"), JMeterUtils.getResString((String)"warning"), -1, 0);
        }
    }
}

