/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import kg.apc.charting.GraphPanelChart;
import kg.apc.cmd.UniversalRunner;
import kg.apc.jmeter.CMDLineArgumentsProcessor;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PluginsCMDWorker {
    private int graphWidth = 800;
    private int graphHeight = 600;
    public static final int EXPORT_PNG = 1;
    public static final int EXPORT_CSV = 2;
    private int exportMode = 0;
    private String inputFile;
    private String outputCSV;
    private String outputPNG;
    private AbstractGraphPanelVisualizer pluginType;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private int aggregate = -1;
    private int zeroing = -1;
    private int preventOutliers = -1;
    private int rowsLimit = -1;
    private int forceY = -1;
    private int lowCounts = -1;
    private int granulation = -1;
    private int relativeTimes = -1;
    private int gradient = -1;
    private int autoScaleRows = -1;
    private float lineWeight = -1.0f;
    private String includeLabels = "";
    private String excludeLabels = "";
    private int successFilter = -1;

    public PluginsCMDWorker() {
        log.info("Using JMeterPluginsCMD v. " + JMeterPluginsUtils.getVersion());
        this.prepareJMeterEnv();
    }

    private void prepareJMeterEnv() {
        File dir;
        if (JMeterUtils.getJMeterHome() != null) {
            log.warn("JMeter env exists. No one should see this normally.");
            return;
        }
        String homeDir = UniversalRunner.getJARLocation();
        log.debug("Orig jmeter home dir: " + homeDir);
        for (dir = new File(homeDir); dir != null && dir.exists() && dir.getName().equals("ext") && dir.getParentFile().getName().equals("lib"); dir = dir.getParentFile()) {
        }
        if (dir == null || !dir.exists()) {
            throw new IllegalArgumentException("CMDRunner.jar must be placed in <jmeter>/lib/ext directory");
        }
        homeDir = dir.getParent();
        if (!this.isJMeterHome(homeDir)) {
            homeDir = PluginsCMDWorker.getJMeterHomeFromCP(System.getProperty("java.class.path"));
        }
        log.debug("Final jmeter home dir: " + homeDir);
        JMeterUtils.setJMeterHome((String)homeDir);
        this.initializeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProperties() {
        String sysProp;
        JMeterUtils.loadJMeterProperties((String)(JMeterUtils.getJMeterHome() + File.separator + "bin" + File.separator + "jmeter.properties"));
        JMeterUtils.initLocale();
        Properties jmeterProps = JMeterUtils.getJMeterProperties();
        String userProp = JMeterUtils.getPropDefault((String)"user.properties", (String)"");
        if (userProp.length() > 0) {
            FileInputStream fis = null;
            try {
                File file = JMeterUtils.findFile((String)userProp);
                if (file.canRead()) {
                    log.info("Loading user properties from: " + file.getCanonicalPath());
                    fis = new FileInputStream(file);
                    Properties tmp = new Properties();
                    tmp.load(fis);
                    jmeterProps.putAll((Map<?, ?>)tmp);
                    LoggingManager.setLoggingLevels((Properties)jmeterProps);
                }
            }
            catch (IOException e) {
                log.warn("Error loading user property file: " + userProp, (Throwable)e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    log.warn("There was problem closing file stream", (Throwable)ex);
                }
            }
        }
        if ((sysProp = JMeterUtils.getPropDefault((String)"system.properties", (String)"")).length() > 0) {
            FileInputStream fis = null;
            try {
                File file = JMeterUtils.findFile((String)sysProp);
                if (file.canRead()) {
                    log.info("Loading system properties from: " + file.getCanonicalPath());
                    fis = new FileInputStream(file);
                    System.getProperties().load(fis);
                }
            }
            catch (IOException e) {
                log.warn("Error loading system property file: " + sysProp, (Throwable)e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    log.warn("There was problem closing file stream", (Throwable)ex);
                }
            }
        }
    }

    public void addExportMode(int mode) {
        this.exportMode |= mode;
    }

    public void setInputFile(String string) {
        this.inputFile = string;
    }

    public void setOutputCSVFile(String string) {
        this.outputCSV = string;
    }

    public void setOutputPNGFile(String string) {
        this.outputPNG = string;
    }

    public void setPluginType(String string) {
        this.pluginType = this.getGUIObject(string);
    }

    private void checkParams() {
        if (this.pluginType == null) {
            throw new IllegalArgumentException("Missing plugin type specification");
        }
        if (this.exportMode == 0) {
            throw new IllegalArgumentException("Missing any export specification");
        }
        if (this.inputFile == null) {
            throw new IllegalArgumentException("Missing input JTL file specification");
        }
        if (!new File(this.inputFile).exists()) {
            throw new IllegalArgumentException("Cannot find specified JTL file: " + this.inputFile);
        }
    }

    public void setGraphWidth(int i) {
        this.graphWidth = i;
    }

    public void setGraphHeight(int i) {
        this.graphHeight = i;
    }

    public int doJob() {
        this.checkParams();
        AbstractGraphPanelVisualizer pluginInstance = this.pluginType;
        this.setOptions(pluginInstance);
        CorrectedResultCollector rc = (CorrectedResultCollector)pluginInstance.createTestElement();
        rc.setExcludeLabels(this.excludeLabels);
        rc.setIncludeLabels(this.includeLabels);
        if (this.successFilter >= 0) {
            rc.setErrorLogging(this.successFilter == 0);
            rc.setSuccessOnlyLogging(this.successFilter != 0);
        }
        log.debug("Using JTL file: " + this.inputFile);
        rc.setFilename(this.inputFile);
        rc.setListener((Visualizer)pluginInstance);
        pluginInstance.configure((TestElement)rc);
        rc.loadExistingFile();
        this.setOptions(pluginInstance);
        if ((this.exportMode & 1) == 1) {
            File pngFile = new File(this.outputPNG);
            this.forceDir(pngFile);
            try {
                pluginInstance.getGraphPanelChart().saveGraphToPNG(pngFile, this.graphWidth, this.graphHeight);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if ((this.exportMode & 2) == 2) {
            File csvFile = new File(this.outputCSV);
            this.forceDir(csvFile);
            try {
                pluginInstance.getGraphPanelChart().saveGraphToCSV(csvFile);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return 0;
    }

    private AbstractGraphPanelVisualizer getGUIObject(String pluginType) {
        Class<?> a;
        try {
            a = Class.forName(pluginType);
        }
        catch (ClassNotFoundException ex) {
            if (!pluginType.endsWith("Gui")) {
                return this.getGUIObject(pluginType + "Gui");
            }
            if (!pluginType.startsWith("kg.apc.jmeter.vizualizers.")) {
                return this.getGUIObject("kg.apc.jmeter.vizualizers." + pluginType);
            }
            throw new RuntimeException(ex);
        }
        try {
            return (AbstractGraphPanelVisualizer)a.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setOptions(AbstractGraphPanelVisualizer gui) {
        GraphPanelChart graph = gui.getGraphPanelChart();
        if (this.aggregate >= 0) {
            gui.switchModel(this.aggregate > 0);
        }
        if (this.granulation >= 0) {
            gui.setGranulation(this.granulation);
        }
        if (this.relativeTimes >= 0) {
            graph.setUseRelativeTime(this.relativeTimes > 0);
        }
        if (this.lineWeight >= 0.0f) {
            graph.getChartSettings().setLineWidth(this.lineWeight);
        }
        if (this.gradient >= 0) {
            graph.getChartSettings().setDrawGradient(this.gradient > 0);
        }
        if (this.zeroing >= 0) {
            graph.getChartSettings().setDrawFinalZeroingLines(this.zeroing > 0);
        }
        if (this.rowsLimit >= 0) {
            graph.getChartSettings().setMaxPointPerRow(this.rowsLimit);
        }
        if (this.preventOutliers >= 0) {
            graph.getChartSettings().setPreventXAxisOverScaling(this.preventOutliers > 0);
        }
        if (this.lowCounts >= 0) {
            graph.getChartSettings().setHideNonRepValLimit(this.lowCounts);
        }
        if (this.forceY >= 0) {
            graph.getChartSettings().setForcedMaxY(this.forceY);
        }
        if (this.autoScaleRows >= 0) {
            graph.getChartSettings().setExpendRows(this.autoScaleRows > 0);
        }
    }

    public void setAggregate(int logicValue) {
        this.aggregate = logicValue;
    }

    public void setZeroing(int logicValue) {
        this.zeroing = logicValue;
    }

    public void setPreventOutliers(int logicValue) {
        this.preventOutliers = logicValue;
    }

    public void setRowsLimit(int parseInt) {
        this.rowsLimit = parseInt;
    }

    public void setForceY(int parseInt) {
        this.forceY = parseInt;
    }

    public void setHideLowCounts(int parseInt) {
        this.lowCounts = parseInt;
    }

    public void setGranulation(int parseInt) {
        this.granulation = parseInt;
    }

    public void setRelativeTimes(int logicValue) {
        this.relativeTimes = logicValue;
    }

    public void setGradient(int logicValue) {
        this.gradient = logicValue;
    }

    public void setIncludeLabels(String string) {
        this.includeLabels = string;
    }

    public void setExcludeLabels(String string) {
        this.excludeLabels = string;
    }

    public void setAutoScaleRows(int logicValue) {
        this.autoScaleRows = logicValue;
    }

    public void setLineWeight(float parseInt) {
        this.lineWeight = parseInt;
    }

    public void setSuccessFilter(int logicValue) {
        this.successFilter = logicValue;
    }

    private void forceDir(File resultFile) {
        File parent = resultFile.getParentFile();
        if (parent != null && !parent.mkdirs() && !parent.exists()) {
            throw new RuntimeException("Failed to create directory for " + resultFile.getAbsolutePath());
        }
    }

    private boolean isJMeterHome(String homeDir) {
        File f = new File(homeDir + File.separator + "lib" + File.separator + "ext");
        return f.exists() && f.isDirectory();
    }

    public static String getJMeterHomeFromCP(String classpathSTR) {
        String[] paths;
        log.debug("Trying to get JMeter home from classpath");
        String splitter = classpathSTR.indexOf(59) != -1 ? ";" : ":";
        for (String string : paths = classpathSTR.split(splitter)) {
            log.debug("Testing " + string);
            if (!string.endsWith("ApacheJMeter_core.jar")) continue;
            File f = new File(string);
            return f.getParentFile().getParentFile().getParentFile().getAbsolutePath();
        }
        throw new Error("Failed to find JMeter home dir from classpath");
    }

    public void processUnknownOption(String nextArg, ListIterator args) {
        if (this.pluginType == null || !(this.pluginType instanceof CMDLineArgumentsProcessor)) {
            throw new UnsupportedOperationException("Unrecognized option: " + nextArg);
        }
        log.debug("Trying to process unknown option using CMDLineArgumentsProcessor: " + nextArg);
        CMDLineArgumentsProcessor obj = (CMDLineArgumentsProcessor)((Object)this.pluginType);
        obj.processCMDOption(nextArg, args);
    }
}

