/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import kg.apc.jmeter.config.DistributedTestControl;
import kg.apc.jmeter.config.JMeterServerPanel;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ServersListPanel
extends JPanel {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private List<JMeterServerPanel> serversList;

    public ServersListPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.serversList = new LinkedList<JMeterServerPanel>();
    }

    public void clear() {
        this.serversList.clear();
        this.removeAll();
        this.getParent().repaint();
    }

    public void saveToTestElement(DistributedTestControl te) {
        ArrayList<String> names = new ArrayList<String>(this.getCount());
        for (JMeterServerPanel srv : this.serversList) {
            names.add(srv.getServerName());
        }
        log.debug("Saving: " + names.toString());
        te.setData(names);
    }

    public void loadFromTestElement(DistributedTestControl te) {
        CollectionProperty servers = te.getData();
        log.debug("Loading: " + servers.toString());
        this.clear();
        for (int n = 0; n < servers.size(); ++n) {
            log.debug("Adding: " + servers.get(n).toString());
            this.add(servers.get(n).getStringValue());
        }
    }

    public void add(String stringValue) {
        JMeterServerPanel panel = new JMeterServerPanel(stringValue, this);
        this.serversList.add(panel);
        this.add(panel);
        this.getParent().repaint();
    }

    public int getCount() {
        return this.serversList.size();
    }

    public void removeServer(JMeterServerPanel jMeterServerPanel) {
        this.serversList.remove(jMeterServerPanel);
        this.getParent().repaint();
    }
}

