/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.ColorsDispatcher;
import kg.apc.charting.GraphPanelChart;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.GraphPanel;
import kg.apc.jmeter.graphs.SettingsInterface;
import kg.apc.jmeter.vizualizers.CompositeResultCollector;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.ImageVisualizer;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractGraphPanelVisualizer
extends AbstractVisualizer
implements Clearable,
GraphListener,
ImageVisualizer,
SettingsInterface {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected ConcurrentSkipListMap<String, AbstractGraphRow> model;
    protected ConcurrentSkipListMap<String, AbstractGraphRow> modelAggregate;
    protected long lastRepaint = 0L;
    private int interval = 500;
    protected boolean isAggregate = false;
    protected GraphPanel graphPanel;
    protected ColorsDispatcher colors;
    private static final long REPAINT_INTERVAL = 500L;
    public static final String INTERVAL_PROPERTY = "interval_grouping";
    public static final String GRAPH_AGGREGATED = "graph_aggregated";
    private JSettingsPanel settingsPanel = null;
    private List<String> includes = new ArrayList<String>(0);
    private List<String> excludes = new ArrayList<String>(0);
    private JPanel container;
    private boolean filePanelVisible = true;
    private boolean maximized = false;
    private JButton maximizeButton;

    public AbstractGraphPanelVisualizer() {
        this.model = new ConcurrentSkipListMap();
        this.modelAggregate = new ConcurrentSkipListMap();
        this.colors = new ColorsDispatcher();
        this.initGui();
    }

    protected abstract JSettingsPanel createSettingsPanel();

    public abstract String getStaticLabel();

    private void initGui() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), this.getWikiPage()), "North");
        this.container = this.getGraphPanelContainer();
        this.container.add((Component)this.createGraphPanel(), "Center");
        this.add(this.container, "Center");
    }

    protected Component createTitleLabel() {
        JPanel pan = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(this.getStaticLabel());
        Font curFont = titleLabel.getFont();
        titleLabel.setFont(curFont.deriveFont((float)curFont.getSize() + 4.0f));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.weightx = 1.0;
        labelConstraints.fill = 2;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        pan.add((Component)titleLabel, labelConstraints);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.gridx = 1;
        buttonConstraints.gridy = 0;
        buttonConstraints.insets = new Insets(0, 0, 0, 1);
        this.maximizeButton = new JButton(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/img/maximize.png")));
        this.maximizeButton.setFocusable(false);
        this.maximizeButton.setPreferredSize(new Dimension(20, 20));
        this.maximizeButton.setToolTipText("Maximize Panel");
        this.maximizeButton.addActionListener(new MaximizeAction());
        pan.add((Component)this.maximizeButton, buttonConstraints);
        return pan;
    }

    protected void enableMaximize(boolean enable) {
        this.maximizeButton.setVisible(enable);
    }

    protected void hideFilePanel() {
        this.filePanelVisible = false;
        this.getFilePanel().setVisible(false);
    }

    private void toogleMaximize() {
        Component[] components;
        this.maximized = !this.maximized;
        for (Component cmp : components = this.container.getComponents()) {
            if (cmp instanceof GraphPanel) continue;
            cmp.setVisible(!this.maximized);
        }
        this.getFilePanel().setVisible(!this.maximized && this.filePanelVisible);
    }

    protected JPanel getGraphPanelContainer() {
        return new JPanel(new BorderLayout());
    }

    protected GraphPanel createGraphPanel() {
        this.graphPanel = new GraphPanel();
        this.graphPanel.getGraphObject().setRows(this.model);
        this.graphPanel.getGraphObject().setPrecisionLabel(this.interval);
        this.setOptionsFromProperties(this.graphPanel.getGraphObject());
        this.setExtraChartSettings();
        this.settingsPanel = this.createSettingsPanel();
        this.graphPanel.getSettingsTab().add((Component)this.getSettingsPanel(), "Center");
        return this.graphPanel;
    }

    protected void setExtraChartSettings() {
    }

    public void updateGui(Sample sample) {
        long time = System.currentTimeMillis();
        if (time - this.lastRepaint >= 500L) {
            this.updateGui();
            this.repaint();
            this.lastRepaint = time;
        }
    }

    public void updateGui() {
        this.graphPanel.updateGui();
    }

    public void clearData() {
        this.clearRowsFromCompositeModels(this.getModel().getName());
        this.model.clear();
        this.modelAggregate.clear();
        this.colors.reset();
        this.graphPanel.clearRowsTab();
        this.updateGui();
        this.repaint();
    }

    public Image getImage() {
        return this.graphPanel.getGraphImage();
    }

    @Override
    public int getGranulation() {
        return this.interval;
    }

    @Override
    public void setGranulation(int granulation) {
        if (granulation < 1) {
            throw new IllegalArgumentException("Interval cannot be less than 1");
        }
        this.interval = granulation;
        this.getSettingsPanel().setGranulationValue(granulation);
        this.graphPanel.getGraphObject().setPrecisionLabel(granulation);
    }

    public TestElement createTestElement() {
        if (this.collector == null || !(this.collector instanceof CorrectedResultCollector)) {
            this.collector = new CorrectedResultCollector();
        }
        return super.createTestElement();
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty((JMeterProperty)new LongProperty(INTERVAL_PROPERTY, (long)this.interval));
        c.setProperty((JMeterProperty)new BooleanProperty(GRAPH_AGGREGATED, this.isAggregate));
        c.setProperty((JMeterProperty)new StringProperty("include_sample_labels", this.graphPanel.getRowSelectorPanel().getIncludeSampleLabels()));
        c.setProperty((JMeterProperty)new StringProperty("exclude_sample_labels", this.graphPanel.getRowSelectorPanel().getExcludeSampleLabels()));
    }

    public void configure(TestElement el) {
        super.configure(el);
        int intervalProp = el.getPropertyAsInt(INTERVAL_PROPERTY);
        boolean aggregatedProp = el.getPropertyAsBoolean(GRAPH_AGGREGATED, false);
        if (intervalProp > 0) {
            this.setGranulation(intervalProp);
        }
        this.graphPanel.getRowSelectorPanel().setIncludeSampleLabels(el.getPropertyAsString("include_sample_labels"));
        this.graphPanel.getRowSelectorPanel().setExcludeSampleLabels(el.getPropertyAsString("exclude_sample_labels"));
        if (el instanceof CorrectedResultCollector) {
            this.setUpFiltering((CorrectedResultCollector)el);
        }
        this.switchModel(aggregatedProp);
    }

    @Override
    public GraphPanelChart getGraphPanelChart() {
        return this.graphPanel.getGraphObject();
    }

    @Override
    public void switchModel(boolean aggregate) {
        ConcurrentSkipListMap<String, AbstractGraphRow> selectedModel;
        if (aggregate) {
            if (this.modelAggregate.isEmpty() && !this.model.isEmpty()) {
                throw new UnsupportedOperationException("Seems you've requested aggregate mode for graph that don't support it. We apologize...");
            }
            selectedModel = this.modelAggregate;
        } else {
            selectedModel = this.model;
        }
        this.graphPanel.getGraphObject().setRows(selectedModel);
        this.graphPanel.clearRowsTab();
        for (AbstractGraphRow abstractGraphRow : selectedModel.values()) {
            this.graphPanel.addRow(abstractGraphRow);
        }
        this.isAggregate = aggregate;
        this.getSettingsPanel().setAggregateMode(aggregate);
    }

    private void addRowToCompositeModels(String rowName, AbstractGraphRow row) {
        GuiPackage gui = GuiPackage.getInstance();
        if (gui == null) {
            log.debug("No GUI Package present, ignored adding to composite");
            return;
        }
        JMeterTreeModel testTree = gui.getTreeModel();
        for (JMeterTreeNode obj : testTree.getNodesOfType(CompositeResultCollector.class)) {
            CompositeResultCollector compositeResultCollector = (CompositeResultCollector)obj.getTestElement();
            compositeResultCollector.getCompositeModel().addRow(rowName, row);
        }
    }

    private void clearRowsFromCompositeModels(String vizualizerName) {
        GuiPackage gui = GuiPackage.getInstance();
        JMeterTreeModel testTree = gui.getTreeModel();
        for (JMeterTreeNode obj : testTree.getNodesOfType(CompositeResultCollector.class)) {
            CompositeResultCollector compositeResultCollector = (CompositeResultCollector)obj.getTestElement();
            compositeResultCollector.getCompositeModel().clearRows(vizualizerName);
        }
    }

    protected synchronized AbstractGraphRow getNewRow(ConcurrentSkipListMap<String, AbstractGraphRow> model, int rowType, String label, int markerSize, boolean isBarRow, boolean displayLabel, boolean thickLines, boolean showInLegend, Color color, boolean canCompose) {
        AbstractGraphRow row;
        if (!model.containsKey(label)) {
            row = AbstractGraphRow.instantiateNewRow(rowType);
            row.setLabel(label);
            row.setMarkerSize(markerSize);
            row.setDrawBar(isBarRow);
            row.setDrawLine(!isBarRow);
            row.setDrawValueLabel(displayLabel);
            row.setDrawThickLines(thickLines);
            row.setShowInLegend(showInLegend);
            if (color == null) {
                row.setColor(this.colors.getNextColor());
            } else {
                row.setColor(color);
            }
            model.put(label, row);
            this.graphPanel.addRow(row);
            if (canCompose) {
                this.addRowToCompositeModels(this.getModel().getName(), row);
            }
        } else {
            row = model.get(label);
        }
        return row;
    }

    protected synchronized AbstractGraphRow getNewRow(ConcurrentSkipListMap<String, AbstractGraphRow> model, int rowType, String label, int markerSize, boolean isBarRow, boolean displayLabel, boolean thickLines, boolean showInLegend, boolean canCompose) {
        return this.getNewRow(model, rowType, label, markerSize, isBarRow, displayLabel, thickLines, showInLegend, null, canCompose);
    }

    protected boolean isFromTransactionControler(SampleResult res) {
        return res.getResponseMessage() != null && res.getResponseMessage().startsWith("Number of samples in transaction");
    }

    public JSettingsPanel getSettingsPanel() {
        return this.settingsPanel;
    }

    private void setOptionsFromProperties(GraphPanelChart graph) {
        boolean removeMarkers;
        String cfgGraphLineMarker;
        String cfgGraphLineWitdh;
        String cfgUseRelativeTime;
        String cfgCsvSeparator;
        String cfgNeverDrawFinalCurrentX;
        String cfgOptimizeYAxis;
        String cfgNeverDrawFinalZeroingLines;
        String cfgDrawGradient = JMeterUtils.getProperty((String)"jmeterPlugin.drawGradient");
        if (cfgDrawGradient != null) {
            graph.getChartSettings().setDrawGradient("true".equalsIgnoreCase(cfgDrawGradient.trim()));
        }
        if ((cfgNeverDrawFinalZeroingLines = JMeterUtils.getProperty((String)"jmeterPlugin.neverDrawFinalZeroingLines")) != null) {
            graph.getChartSettings().setConfigNeverDrawFinalZeroingLines("true".equalsIgnoreCase(cfgNeverDrawFinalZeroingLines.trim()));
        }
        if ((cfgOptimizeYAxis = JMeterUtils.getProperty((String)"jmeterPlugin.optimizeYAxis")) != null) {
            graph.getChartSettings().setConfigOptimizeYAxis("true".equalsIgnoreCase(cfgOptimizeYAxis.trim()));
        }
        if ((cfgNeverDrawFinalCurrentX = JMeterUtils.getProperty((String)"jmeterPlugin.neverDrawCurrentX")) != null) {
            graph.getChartSettings().setConfigNeverDrawCurrentX("true".equalsIgnoreCase(cfgNeverDrawFinalCurrentX.trim()));
        }
        if ((cfgCsvSeparator = JMeterUtils.getProperty((String)"jmeterPlugin.csvSeparator")) != null) {
            graph.getChartSettings().setConfigCsvSeparator(cfgCsvSeparator);
        }
        if ((cfgUseRelativeTime = JMeterUtils.getProperty((String)"jmeterPlugin.useRelativeTime")) != null) {
            graph.getChartSettings().setUseRelativeTime("true".equalsIgnoreCase(cfgUseRelativeTime.trim()));
        }
        if ((cfgGraphLineWitdh = JMeterUtils.getProperty((String)"jmeterPlugin.graphLineWidth")) != null) {
            graph.getChartSettings().setLineWidth(JMeterPluginsUtils.getFloatFromString(cfgGraphLineWitdh, 1.0f));
        }
        if ((cfgGraphLineMarker = JMeterUtils.getProperty((String)"jmeterPlugin.drawLineMarker")) != null && (removeMarkers = "false".equalsIgnoreCase(cfgGraphLineMarker.trim()))) {
            graph.getChartSettings().setChartMarkers(2);
        }
    }

    protected boolean isSampleIncluded(SampleResult res) {
        if (!this.includes.isEmpty() && !this.includes.contains(res.getSampleLabel())) {
            return false;
        }
        return this.excludes.isEmpty() || !this.excludes.contains(res.getSampleLabel());
    }

    protected boolean isSampleIncluded(String sampleLabel) {
        if (!this.includes.isEmpty() && !this.includes.contains(sampleLabel)) {
            return false;
        }
        return this.excludes.isEmpty() || !this.excludes.contains(sampleLabel);
    }

    public void setUpFiltering(CorrectedResultCollector rc) {
        this.includes = rc.getList("include_sample_labels");
        this.excludes = rc.getList("exclude_sample_labels");
    }

    private class MaximizeAction
    implements ActionListener {
        private MaximizeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractGraphPanelVisualizer.this.toogleMaximize();
            if (!AbstractGraphPanelVisualizer.this.maximized) {
                AbstractGraphPanelVisualizer.this.maximizeButton.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/img/maximize.png")));
                AbstractGraphPanelVisualizer.this.maximizeButton.setToolTipText("Maximize Panel");
            } else {
                AbstractGraphPanelVisualizer.this.maximizeButton.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/img/restore.png")));
                AbstractGraphPanelVisualizer.this.maximizeButton.setToolTipText("Restore Panel");
            }
        }
    }
}

