/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FlexibleFileWriter
extends AbstractListenerElement
implements SampleListener,
Serializable,
TestListener,
Remoteable,
NoThreadClone {
    public static final String AVAILABLE_FIELDS = "isSuccsessful startTime endTime sentBytes receivedBytes responseTime latency responseCode responseMessage isFailed threadName sampleLabel startTimeMillis endTimeMillis responseTimeMicros latencyMicros requestData responseData responseHeaders threadsCount ";
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String OVERWRITE = "overwrite";
    private static final String FILENAME = "filename";
    private static final String COLUMNS = "columns";
    private static final String HEADER = "header";
    private static final String FOOTER = "footer";
    private static final String VAR_PREFIX = "variable#";
    protected volatile FileChannel fileChannel;
    private int[] compiledVars;
    private int[] compiledFields;
    private ByteBuffer[] compiledConsts;
    private ArrayList<String> availableFieldNames = new ArrayList<String>(Arrays.asList("isSuccsessful startTime endTime sentBytes receivedBytes responseTime latency responseCode responseMessage isFailed threadName sampleLabel startTimeMillis endTimeMillis responseTimeMicros latencyMicros requestData responseData responseHeaders threadsCount ".trim().split(" ")));
    private static final byte[] b1 = "1".getBytes();
    private static final byte[] b0 = "0".getBytes();

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void testStarted() {
        this.compileColumns();
        try {
            this.openFile();
        }
        catch (FileNotFoundException ex) {
            log.error("Cannot open file " + this.getFilename(), (Throwable)ex);
        }
        catch (IOException ex) {
            log.error("Cannot write file header " + this.getFilename(), (Throwable)ex);
        }
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded() {
        this.closeFile();
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    public void setFilename(String name) {
        this.setProperty(FILENAME, name);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public void setColumns(String cols) {
        this.setProperty(COLUMNS, cols);
    }

    public String getColumns() {
        return this.getPropertyAsString(COLUMNS);
    }

    public boolean isOverwrite() {
        return this.getPropertyAsBoolean(OVERWRITE, false);
    }

    public void setOverwrite(boolean ov) {
        this.setProperty(OVERWRITE, ov);
    }

    public void setFileHeader(String str) {
        this.setProperty(HEADER, str);
    }

    public String getFileHeader() {
        return this.getPropertyAsString(HEADER);
    }

    public void setFileFooter(String str) {
        this.setProperty(FOOTER, str);
    }

    public String getFileFooter() {
        return this.getPropertyAsString(FOOTER);
    }

    private void compileColumns() {
        log.debug("Compiling columns string: " + this.getColumns());
        String[] chunks = JMeterPluginsUtils.replaceRNT(this.getColumns()).split("\\|");
        log.debug("Chunks " + chunks.length);
        this.compiledFields = new int[chunks.length];
        this.compiledVars = new int[chunks.length];
        this.compiledConsts = new ByteBuffer[chunks.length];
        for (int n = 0; n < chunks.length; ++n) {
            int fieldID = this.availableFieldNames.indexOf(chunks[n]);
            if (fieldID >= 0) {
                this.compiledFields[n] = fieldID;
                continue;
            }
            this.compiledFields[n] = -1;
            this.compiledVars[n] = -1;
            if (chunks[n].indexOf(VAR_PREFIX) >= 0) {
                log.debug(chunks[n] + " is sample variable");
                String varN = chunks[n].substring(VAR_PREFIX.length());
                try {
                    this.compiledVars[n] = Integer.parseInt(varN);
                }
                catch (NumberFormatException e) {
                    log.error("Seems it is not variable spec: " + chunks[n]);
                    this.compiledConsts[n] = ByteBuffer.wrap(chunks[n].getBytes());
                }
                continue;
            }
            log.debug(chunks[n] + " is const");
            if (chunks[n].length() == 0) {
                chunks[n] = "|";
            }
            this.compiledConsts[n] = ByteBuffer.wrap(chunks[n].getBytes());
        }
    }

    protected void openFile() throws IOException {
        String filename = this.getFilename();
        FileOutputStream fos = new FileOutputStream(filename, !this.isOverwrite());
        this.fileChannel = fos.getChannel();
        String header = this.getFileHeader();
        if (!header.isEmpty()) {
            this.fileChannel.write(ByteBuffer.wrap(header.getBytes()));
        }
    }

    private synchronized void closeFile() {
        if (this.fileChannel != null && this.fileChannel.isOpen()) {
            try {
                String footer = this.getFileFooter();
                if (!footer.isEmpty()) {
                    this.fileChannel.write(ByteBuffer.wrap(footer.getBytes()));
                }
                this.fileChannel.force(false);
                this.fileChannel.close();
            }
            catch (IOException ex) {
                log.error("Failed to close file: " + this.getFilename(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void sampleOccurred(SampleEvent evt) {
        if (this.fileChannel == null || !this.fileChannel.isOpen()) {
            if (!log.isWarnEnabled()) return;
            log.warn("File writer is closed! Maybe test has already been stopped");
            return;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(10240);
        for (int n = 0; n < this.compiledConsts.length; ++n) {
            if (this.compiledConsts[n] != null) {
                ByteBuffer[] byteBufferArray = this.compiledConsts;
                // MONITORENTER : this.compiledConsts
                buf.put(this.compiledConsts[n].duplicate());
                // MONITOREXIT : byteBufferArray
                continue;
            }
            if (this.appendSampleResultField(buf, evt.getResult(), this.compiledFields[n])) continue;
            this.appendSampleVariable(buf, evt, this.compiledVars[n]);
        }
        buf.flip();
        try {
            this.syncWrite(buf);
            return;
        }
        catch (IOException ex) {
            log.error("Problems writing to file", (Throwable)ex);
        }
    }

    private synchronized void syncWrite(ByteBuffer buf) throws IOException {
        FileLock lock = this.fileChannel.lock();
        this.fileChannel.write(buf);
        lock.release();
    }

    private String getShiftDecimal(long number, int shift) {
        StringBuilder builder = new StringBuilder();
        builder.append(number);
        int index = builder.length() - shift;
        builder.insert(index, ".");
        return builder.toString();
    }

    private void appendSampleVariable(ByteBuffer buf, SampleEvent evt, int varID) {
        if (SampleEvent.getVarCount() < varID + 1) {
            buf.put(("UNDEFINED_variable#" + varID).getBytes());
            log.warn(VAR_PREFIX + varID + " does not exist!");
        } else if (evt.getVarValue(varID) != null) {
            buf.put(evt.getVarValue(varID).getBytes());
        }
    }

    private boolean appendSampleResultField(ByteBuffer buf, SampleResult result, int fieldID) {
        switch (fieldID) {
            case 0: {
                buf.put(result.isSuccessful() ? b1 : b0);
                break;
            }
            case 1: {
                buf.put(String.valueOf(result.getStartTime()).getBytes());
                break;
            }
            case 2: {
                buf.put(String.valueOf(result.getEndTime()).getBytes());
                break;
            }
            case 3: {
                if (result.getSamplerData() != null) {
                    buf.put(String.valueOf(result.getSamplerData().length()).getBytes());
                    break;
                }
                buf.put(b0);
                break;
            }
            case 4: {
                if (result.getResponseData() != null) {
                    buf.put(String.valueOf(result.getResponseData().length).getBytes());
                    break;
                }
                buf.put(b0);
                break;
            }
            case 5: {
                buf.put(String.valueOf(result.getTime()).getBytes());
                break;
            }
            case 6: {
                buf.put(String.valueOf(result.getLatency()).getBytes());
                break;
            }
            case 7: {
                buf.put(result.getResponseCode().getBytes());
                break;
            }
            case 8: {
                buf.put(result.getResponseMessage().getBytes());
                break;
            }
            case 9: {
                buf.put(!result.isSuccessful() ? b1 : b0);
                break;
            }
            case 10: {
                buf.put(result.getThreadName().getBytes());
                break;
            }
            case 11: {
                buf.put(result.getSampleLabel().getBytes());
                break;
            }
            case 12: {
                buf.put(this.getShiftDecimal(result.getStartTime(), 3).getBytes());
                break;
            }
            case 13: {
                buf.put(this.getShiftDecimal(result.getEndTime(), 3).getBytes());
                break;
            }
            case 14: {
                buf.put(String.valueOf(result.getTime() * 1000L).getBytes());
                break;
            }
            case 15: {
                buf.put(String.valueOf(result.getLatency() * 1000L).getBytes());
                break;
            }
            case 16: {
                buf.put(result.getSamplerData().getBytes());
                break;
            }
            case 17: {
                buf.put(result.getResponseData());
                break;
            }
            case 18: {
                buf.put(result.getRequestHeaders().getBytes());
                break;
            }
            case 19: {
                buf.put(String.valueOf(result.getAllThreads()).getBytes());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

