/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.GraphRendererInterface;
import kg.apc.jmeter.graphs.SettingsInterface;

public class JSettingsPanel
extends JPanel
implements GraphRendererInterface {
    public static final int TIMELINE_OPTION = 1;
    public static final int GRADIENT_OPTION = 2;
    public static final int CURRENTX_OPTION = 4;
    public static final int FINAL_ZEROING_OPTION = 8;
    public static final int LIMIT_POINT_OPTION = 16;
    public static final int BAR_CHART_X_LIMIT_OPTION = 32;
    public static final int HIDE_NON_REP_VALUES_OPTION = 64;
    public static final int AGGREGATE_OPTION = 128;
    public static final int RELATIVE_TIME_OPTION = 256;
    public static final int MAXY_OPTION = 512;
    public static final int CHART_TYPE_OPTION = 1024;
    public static final int MARKERS_OPTION = 2048;
    public static final int AUTO_EXPAND_OPTION = 4096;
    public static final int MARKERS_OPTION_DISABLED = 8192;
    private SettingsInterface parent = null;
    private int originalTooltipDisplayTime = 0;
    private ButtonGroup buttonGroupGraphType;
    private JCheckBox jCheckBoxAutoExpand;
    private JCheckBox jCheckBoxDrawCurrentX;
    private JCheckBox jCheckBoxDrawFinalZeroingLines;
    private JCheckBox jCheckBoxDrawMarkers;
    private JCheckBox jCheckBoxHideNonRepValues;
    private JCheckBox jCheckBoxLimitMaxXValue;
    private JCheckBox jCheckBoxMaxPoints;
    private JCheckBox jCheckBoxMaxY;
    private JCheckBox jCheckBoxPaintGradient;
    private JCheckBox jCheckBoxRelativeTime;
    private JComboBox jComboBoxChartType;
    private JComboBox jComboBoxGranulation;
    private JComboBox jComboBoxHideNonRepValLimit;
    private JComboBox jComboBoxLineWidth;
    private JComboBox jComboBoxMaxPoints;
    private JLabel jLabel2;
    private JLabel jLabelChartType;
    private JLabel jLabelGraphType;
    private JLabel jLabelHideNonRepPoints;
    private JLabel jLabelInfoGrpValues;
    private JLabel jLabelInfoMaxPoint;
    private JLabel jLabelLineWidth;
    private JLabel jLabelLogo;
    private JLabel jLabelMaxPoints;
    private JLabel jLabelTimeline1;
    private JLabel jLabelTimeline2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanelAllSettingsContainer;
    private JPanel jPanelGraphPreview;
    private JPanel jPanelGraphPreviewContainer;
    private JPanel jPanelGraphStyle;
    private JPanel jPanelLogo;
    private JPanel jPanelRenderingOptionsContainer;
    private JPanel jPanelTimeLineContainer;
    private JRadioButton jRadioButtonGraphAggregated;
    private JRadioButton jRadioButtonGraphDetailed;
    private JTextField jTextFieldMaxY;

    public JSettingsPanel(SettingsInterface parent, int options) {
        boolean showTimelineOption = (options & 1) != 0;
        boolean showGradientOption = (options & 2) != 0;
        boolean showCurrentXOption = (options & 4) != 0;
        boolean showFinalZeroingLinesOption = (options & 8) != 0;
        boolean showLimitPointOption = (options & 0x10) != 0;
        boolean showBarChartXAxisLimit = (options & 0x20) != 0;
        boolean showHideNonRepValues = (options & 0x40) != 0;
        boolean showAggregateOption = (options & 0x80) != 0;
        boolean showRelativeTimeOption = (options & 0x100) != 0;
        boolean showMaxYOption = (options & 0x200) != 0;
        boolean showGraphTypeOption = (options & 0x400) != 0;
        boolean showMarkersOption = (options & 0x800) != 0 || (options & 0x2000) != 0;
        boolean showAutoExpandOption = (options & 0x1000) != 0;
        boolean markerOptionDisabled = (options & 0x2000) != 0;
        this.initComponents();
        this.parent = parent;
        this.postInitComponents(showTimelineOption, showGradientOption, showCurrentXOption, showFinalZeroingLinesOption, showLimitPointOption, showBarChartXAxisLimit, showHideNonRepValues, showAggregateOption, showRelativeTimeOption, showMaxYOption, showGraphTypeOption, showMarkersOption, showAutoExpandOption, markerOptionDisabled);
        this.registerJTextfieldForRefresh(this.jTextFieldMaxY);
    }

    private void postInitComponents(boolean showTimelineOption, boolean showGradientOption, boolean showCurrentXOption, boolean showFinalZeroingLinesOption, boolean showLimitPointOption, boolean showBarChartXAxisLimit, boolean showHideNonRepValues, boolean showAggregateOption, boolean showRelativeTimeOption, boolean showMaxYOption, boolean showGraphTypeOption, boolean showMarkersOption, boolean showAutoExpandOption, boolean markerOptionDisabled) {
        this.jPanelTimeLineContainer.setVisible(showTimelineOption || showAggregateOption || showRelativeTimeOption);
        this.jPanelRenderingOptionsContainer.setVisible(showGradientOption || showCurrentXOption || showFinalZeroingLinesOption || showLimitPointOption || showBarChartXAxisLimit || showHideNonRepValues || showMaxYOption);
        this.jPanelGraphStyle.setVisible(showGraphTypeOption || showMarkersOption);
        this.jLabelTimeline1.setVisible(showTimelineOption);
        this.jLabelTimeline2.setVisible(showTimelineOption);
        this.jComboBoxGranulation.setVisible(showTimelineOption);
        this.jLabelInfoGrpValues.setVisible(showTimelineOption);
        this.jCheckBoxRelativeTime.setVisible(showRelativeTimeOption);
        this.jCheckBoxAutoExpand.setVisible(showAutoExpandOption);
        this.jRadioButtonGraphAggregated.setVisible(showAggregateOption);
        this.jRadioButtonGraphDetailed.setVisible(showAggregateOption);
        this.jLabelGraphType.setVisible(showAggregateOption);
        this.jCheckBoxPaintGradient.setVisible(showGradientOption);
        this.jCheckBoxDrawCurrentX.setVisible(showCurrentXOption);
        this.jCheckBoxDrawFinalZeroingLines.setVisible(showFinalZeroingLinesOption);
        this.jCheckBoxMaxPoints.setVisible(showLimitPointOption);
        this.jComboBoxMaxPoints.setVisible(showLimitPointOption);
        this.jLabelMaxPoints.setVisible(showLimitPointOption);
        this.jLabelInfoMaxPoint.setVisible(showLimitPointOption);
        this.originalTooltipDisplayTime = ToolTipManager.sharedInstance().getDismissDelay();
        this.jCheckBoxPaintGradient.setSelected(this.parent.getGraphPanelChart().getChartSettings().isDrawGradient());
        this.jCheckBoxDrawCurrentX.setSelected(this.parent.getGraphPanelChart().getChartSettings().isDrawCurrentX());
        this.jCheckBoxRelativeTime.setSelected(this.parent.getGraphPanelChart().getChartSettings().isUseRelativeTime());
        if (showFinalZeroingLinesOption) {
            this.jCheckBoxDrawFinalZeroingLines.setSelected(this.parent.getGraphPanelChart().getChartSettings().isDrawFinalZeroingLines());
        }
        this.jCheckBoxLimitMaxXValue.setVisible(showBarChartXAxisLimit);
        this.jComboBoxHideNonRepValLimit.setVisible(showHideNonRepValues);
        this.jCheckBoxHideNonRepValues.setVisible(showHideNonRepValues);
        this.jLabelHideNonRepPoints.setVisible(showHideNonRepValues);
        this.jCheckBoxMaxY.setVisible(showMaxYOption);
        this.jTextFieldMaxY.setVisible(showMaxYOption);
        this.jComboBoxChartType.setVisible(showGraphTypeOption);
        this.jLabelChartType.setVisible(showGraphTypeOption);
        this.jCheckBoxDrawMarkers.setVisible(showMarkersOption);
        this.jLabelLineWidth.setVisible(showMarkersOption);
        this.jComboBoxLineWidth.setVisible(showMarkersOption);
        if (showGraphTypeOption) {
            this.jCheckBoxDrawMarkers.setVisible(false);
            this.jLabelLineWidth.setVisible(false);
            this.jComboBoxLineWidth.setVisible(false);
        } else {
            this.jCheckBoxDrawMarkers.setSelected(!markerOptionDisabled);
        }
        float width = this.parent.getGraphPanelChart().getChartSettings().getLineWidth();
        if (width % 1.0f == 0.0f) {
            this.jComboBoxLineWidth.setSelectedItem((int)width);
        } else {
            this.jComboBoxLineWidth.setSelectedItem(Float.valueOf(width));
        }
        if (this.parent.getGraphPanelChart().getChartSettings().getChartMarkers() == 2) {
            this.jCheckBoxDrawMarkers.setSelected(false);
        }
    }

    private void refreshGraphPreview() {
        this.parent.getGraphPanelChart().invalidateCache();
        this.jPanelGraphPreview.invalidate();
        this.jPanelGraphPreview.repaint();
    }

    @Override
    public JPanel getGraphDisplayPanel() {
        return this.jPanelGraphPreview;
    }

    private int getValueFromString(String sValue) {
        int ret;
        try {
            ret = Integer.valueOf(sValue);
            if (ret <= 0) {
                ret = -1;
            }
        }
        catch (NumberFormatException ex) {
            ret = -1;
        }
        return ret;
    }

    public void setAggregateMode(boolean aggregate) {
        if (aggregate) {
            this.jRadioButtonGraphAggregated.setSelected(true);
        } else {
            this.jRadioButtonGraphDetailed.setSelected(true);
        }
    }

    public void setGranulationValue(int value) {
        this.jComboBoxGranulation.setSelectedItem(Integer.toString(value));
    }

    private void initComponents() {
        this.buttonGroupGraphType = new ButtonGroup();
        this.jPanelLogo = new JPanel();
        this.jLabelLogo = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanelAllSettingsContainer = new JPanel();
        this.jPanelTimeLineContainer = new JPanel();
        this.jLabelTimeline1 = new JLabel();
        this.jLabelTimeline2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jComboBoxGranulation = new JComboBox();
        this.jLabelInfoGrpValues = new JLabel();
        this.jRadioButtonGraphAggregated = new JRadioButton();
        this.jRadioButtonGraphDetailed = new JRadioButton();
        this.jLabelGraphType = new JLabel();
        this.jCheckBoxRelativeTime = new JCheckBox();
        this.jCheckBoxAutoExpand = new JCheckBox();
        this.jPanelRenderingOptionsContainer = new JPanel();
        this.jCheckBoxPaintGradient = new JCheckBox();
        this.jCheckBoxDrawFinalZeroingLines = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jCheckBoxDrawCurrentX = new JCheckBox();
        this.jCheckBoxMaxPoints = new JCheckBox();
        this.jLabelMaxPoints = new JLabel();
        this.jComboBoxMaxPoints = new JComboBox();
        this.jLabelInfoMaxPoint = new JLabel();
        this.jCheckBoxLimitMaxXValue = new JCheckBox();
        this.jCheckBoxHideNonRepValues = new JCheckBox();
        this.jComboBoxHideNonRepValLimit = new JComboBox();
        this.jLabelHideNonRepPoints = new JLabel();
        this.jCheckBoxMaxY = new JCheckBox();
        this.jTextFieldMaxY = new JTextField();
        this.jPanelGraphPreviewContainer = new JPanel();
        this.jPanelGraphPreview = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanelGraphStyle = new JPanel();
        this.jLabelChartType = new JLabel();
        this.jComboBoxChartType = new JComboBox();
        this.jCheckBoxDrawMarkers = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabelLineWidth = new JLabel();
        this.jComboBoxLineWidth = new JComboBox();
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new BorderLayout());
        this.jPanelLogo.setLayout(new GridBagLayout());
        this.jLabelLogo.setHorizontalAlignment(4);
        this.jLabelLogo.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/logoSimple.png")));
        this.jLabelLogo.setCursor(new Cursor(12));
        this.jLabelLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSettingsPanel.this.jLabelLogoMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanelLogo.add((Component)this.jLabelLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelLogo.add((Component)this.jPanel1, gridBagConstraints);
        this.add((Component)this.jPanelLogo, "Last");
        this.jPanelAllSettingsContainer.setLayout(new GridBagLayout());
        this.jPanelTimeLineContainer.setBorder(BorderFactory.createTitledBorder("Graph Settings"));
        this.jPanelTimeLineContainer.setLayout(new GridBagLayout());
        this.jLabelTimeline1.setText("Group timeline values for");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 8, 2);
        this.jPanelTimeLineContainer.add((Component)this.jLabelTimeline1, gridBagConstraints);
        this.jLabelTimeline2.setText("ms");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 8, 2);
        this.jPanelTimeLineContainer.add((Component)this.jLabelTimeline2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelTimeLineContainer.add((Component)this.jPanel4, gridBagConstraints);
        this.jComboBoxGranulation.setEditable(true);
        this.jComboBoxGranulation.setModel(new DefaultComboBoxModel<String>(new String[]{"100", "500", "1000", "2000", "5000", "10000", "30000", "60000"}));
        this.jComboBoxGranulation.setPreferredSize(new Dimension(80, 20));
        this.jComboBoxGranulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jComboBoxGranulationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 8, 2);
        this.jPanelTimeLineContainer.add((Component)this.jComboBoxGranulation, gridBagConstraints);
        this.jLabelInfoGrpValues.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/information.png")));
        this.jLabelInfoGrpValues.setToolTipText("<html>You can specify here the duration used internally<br>\nby the plugin to combine the values received during<br>\nthe test. This will result in <b>more readable graphs</b> and<br>\n<b>less resources needs</b>. It <b>cannot be undo</b>.<br>\nYou can change the value during the test, but it is not<br>\nrecomended as it may produce inconsistant graphs.<br>\nThis parameter is saved with the test plan.");
        this.jLabelInfoGrpValues.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JSettingsPanel.this.infoLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JSettingsPanel.this.infoLabelMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 8, 2);
        this.jPanelTimeLineContainer.add((Component)this.jLabelInfoGrpValues, gridBagConstraints);
        this.buttonGroupGraphType.add(this.jRadioButtonGraphAggregated);
        this.jRadioButtonGraphAggregated.setText("Aggregated display, all Samplers combined");
        this.jRadioButtonGraphAggregated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jRadioButtonGraphAggregatedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.jPanelTimeLineContainer.add((Component)this.jRadioButtonGraphAggregated, gridBagConstraints);
        this.buttonGroupGraphType.add(this.jRadioButtonGraphDetailed);
        this.jRadioButtonGraphDetailed.setSelected(true);
        this.jRadioButtonGraphDetailed.setText("Detailed display, one row per Sampler");
        this.jRadioButtonGraphDetailed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jRadioButtonGraphDetailedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.jPanelTimeLineContainer.add((Component)this.jRadioButtonGraphDetailed, gridBagConstraints);
        this.jLabelGraphType.setText("Type of graph:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 4, 2);
        this.jPanelTimeLineContainer.add((Component)this.jLabelGraphType, gridBagConstraints);
        this.jCheckBoxRelativeTime.setText("Use relative times");
        this.jCheckBoxRelativeTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxRelativeTimeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanelTimeLineContainer.add((Component)this.jCheckBoxRelativeTime, gridBagConstraints);
        this.jCheckBoxAutoExpand.setSelected(true);
        this.jCheckBoxAutoExpand.setText("Auto-zoom rows for best fit");
        this.jCheckBoxAutoExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxAutoExpandActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.jPanelTimeLineContainer.add((Component)this.jCheckBoxAutoExpand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelAllSettingsContainer.add((Component)this.jPanelTimeLineContainer, gridBagConstraints);
        this.jPanelRenderingOptionsContainer.setBorder(BorderFactory.createTitledBorder("Rendering Options"));
        this.jPanelRenderingOptionsContainer.setLayout(new GridBagLayout());
        this.jCheckBoxPaintGradient.setText("Paint gradient");
        this.jCheckBoxPaintGradient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxPaintGradientActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanelRenderingOptionsContainer.add((Component)this.jCheckBoxPaintGradient, gridBagConstraints);
        this.jCheckBoxDrawFinalZeroingLines.setText("Draw final zeroing lines");
        this.jCheckBoxDrawFinalZeroingLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxDrawFinalZeroingLinesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanelRenderingOptionsContainer.add((Component)this.jCheckBoxDrawFinalZeroingLines, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelRenderingOptionsContainer.add((Component)this.jPanel6, gridBagConstraints);
        this.jCheckBoxDrawCurrentX.setText("Draw current X line");
        this.jCheckBoxDrawCurrentX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxDrawCurrentXActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelRenderingOptionsContainer.add((Component)this.jCheckBoxDrawCurrentX, gridBagConstraints);
        this.jCheckBoxMaxPoints.setText("Limit number of points in row to");
        this.jCheckBoxMaxPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxMaxPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanelRenderingOptionsContainer.add((Component)this.jCheckBoxMaxPoints, gridBagConstraints);
        this.jLabelMaxPoints.setText("points");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelRenderingOptionsContainer.add((Component)this.jLabelMaxPoints, gridBagConstraints);
        this.jComboBoxMaxPoints.setEditable(true);
        this.jComboBoxMaxPoints.setModel(new DefaultComboBoxModel<String>(new String[]{"20", "50", "100", "150", "200"}));
        this.jComboBoxMaxPoints.setSelectedIndex(1);
        this.jComboBoxMaxPoints.setPreferredSize(new Dimension(50, 20));
        this.jComboBoxMaxPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jComboBoxMaxPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelRenderingOptionsContainer.add((Component)this.jComboBoxMaxPoints, gridBagConstraints);
        this.jLabelInfoMaxPoint.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/information.png")));
        this.jLabelInfoMaxPoint.setToolTipText("<html>This option will <b>dynamically</b> adjust the graph<br>\nrendering so it is <b>more readable</b>. It <b>can be undo</b>.<br>\nYou can change the value during the test.<br>\nThis parameter is not saved with the test plan.<br>");
        this.jLabelInfoMaxPoint.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JSettingsPanel.this.infoLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JSettingsPanel.this.infoLabelMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelRenderingOptionsContainer.add((Component)this.jLabelInfoMaxPoint, gridBagConstraints);
        this.jCheckBoxLimitMaxXValue.setText("Prevent X axis range to adapt to outliers");
        this.jCheckBoxLimitMaxXValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxLimitMaxXValueActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.jPanelRenderingOptionsContainer.add((Component)this.jCheckBoxLimitMaxXValue, gridBagConstraints);
        this.jCheckBoxHideNonRepValues.setText("Hide non representative points, if count is less or equal than");
        this.jCheckBoxHideNonRepValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxHideNonRepValuesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        this.jPanelRenderingOptionsContainer.add((Component)this.jCheckBoxHideNonRepValues, gridBagConstraints);
        this.jComboBoxHideNonRepValLimit.setEditable(true);
        this.jComboBoxHideNonRepValLimit.setModel(new DefaultComboBoxModel<String>(new String[]{"5", "10", "15", "20", "50", "100"}));
        this.jComboBoxHideNonRepValLimit.setPreferredSize(new Dimension(50, 20));
        this.jComboBoxHideNonRepValLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jComboBoxHideNonRepValLimitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelRenderingOptionsContainer.add((Component)this.jComboBoxHideNonRepValLimit, gridBagConstraints);
        this.jLabelHideNonRepPoints.setText("occurences");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanelRenderingOptionsContainer.add((Component)this.jLabelHideNonRepPoints, gridBagConstraints);
        this.jCheckBoxMaxY.setText("Force maximum Y axis value to");
        this.jCheckBoxMaxY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxMaxYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.jPanelRenderingOptionsContainer.add((Component)this.jCheckBoxMaxY, gridBagConstraints);
        this.jTextFieldMaxY.setMinimumSize(new Dimension(50, 20));
        this.jTextFieldMaxY.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelRenderingOptionsContainer.add((Component)this.jTextFieldMaxY, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanelAllSettingsContainer.add((Component)this.jPanelRenderingOptionsContainer, gridBagConstraints);
        this.jPanelGraphPreviewContainer.setLayout(new GridBagLayout());
        this.jPanelGraphPreview.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelGraphPreviewContainer.add((Component)this.jPanelGraphPreview, gridBagConstraints);
        this.jLabel2.setText("Preview:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanelGraphPreviewContainer.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelAllSettingsContainer.add((Component)this.jPanelGraphPreviewContainer, gridBagConstraints);
        this.jPanelGraphStyle.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jPanelGraphStyle.setLayout(new GridBagLayout());
        this.jLabelChartType.setText("Chart type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 10, 2);
        this.jPanelGraphStyle.add((Component)this.jLabelChartType, gridBagConstraints);
        this.jComboBoxChartType.setModel(new DefaultComboBoxModel<String>(new String[]{"Line", "Bar", "Cubic Spline"}));
        this.jComboBoxChartType.setSelectedIndex(1);
        this.jComboBoxChartType.setPreferredSize(new Dimension(110, 20));
        this.jComboBoxChartType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jComboBoxChartTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 10, 2);
        this.jPanelGraphStyle.add((Component)this.jComboBoxChartType, gridBagConstraints);
        this.jCheckBoxDrawMarkers.setText("Draw markers");
        this.jCheckBoxDrawMarkers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxDrawMarkersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelGraphStyle.add((Component)this.jCheckBoxDrawMarkers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelGraphStyle.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabelLineWidth.setText("Line width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelGraphStyle.add((Component)this.jLabelLineWidth, gridBagConstraints);
        this.jComboBoxLineWidth.setEditable(true);
        this.jComboBoxLineWidth.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "0.1", "1", "3", "5"}));
        this.jComboBoxLineWidth.setSelectedIndex(2);
        this.jComboBoxLineWidth.setMaximumSize(new Dimension(56, 20));
        this.jComboBoxLineWidth.setMinimumSize(new Dimension(56, 20));
        this.jComboBoxLineWidth.setPreferredSize(new Dimension(56, 20));
        this.jComboBoxLineWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jComboBoxLineWidthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelGraphStyle.add((Component)this.jComboBoxLineWidth, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelAllSettingsContainer.add((Component)this.jPanelGraphStyle, gridBagConstraints);
        this.add((Component)this.jPanelAllSettingsContainer, "Center");
    }

    private void jComboBoxGranulationActionPerformed(ActionEvent evt) {
        int newValue = this.getValueFromString((String)this.jComboBoxGranulation.getSelectedItem());
        if (newValue != -1 && this.parent.getGranulation() != newValue) {
            this.parent.setGranulation(newValue);
        }
    }

    private void jCheckBoxPaintGradientActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().getChartSettings().setDrawGradient(this.jCheckBoxPaintGradient.isSelected());
        this.refreshGraphPreview();
    }

    private void jCheckBoxDrawFinalZeroingLinesActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().getChartSettings().setDrawFinalZeroingLines(this.jCheckBoxDrawFinalZeroingLines.isSelected());
        this.refreshGraphPreview();
    }

    private void jCheckBoxDrawCurrentXActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().getChartSettings().setDrawCurrentX(this.jCheckBoxDrawCurrentX.isSelected());
        this.refreshGraphPreview();
    }

    private void jCheckBoxMaxPointsActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMaxPoints.isSelected()) {
            this.parent.getGraphPanelChart().getChartSettings().setMaxPointPerRow(this.getValueFromString((String)this.jComboBoxMaxPoints.getSelectedItem()));
        } else {
            this.parent.getGraphPanelChart().getChartSettings().setMaxPointPerRow(-1);
        }
        this.refreshGraphPreview();
    }

    private void jComboBoxMaxPointsActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMaxPoints.isSelected()) {
            this.parent.getGraphPanelChart().getChartSettings().setMaxPointPerRow(this.getValueFromString((String)this.jComboBoxMaxPoints.getSelectedItem()));
        }
        this.refreshGraphPreview();
    }

    private void infoLabelMouseEntered(MouseEvent evt) {
        ToolTipManager.sharedInstance().setDismissDelay(60000);
    }

    private void infoLabelMouseExited(MouseEvent evt) {
        ToolTipManager.sharedInstance().setDismissDelay(this.originalTooltipDisplayTime);
    }

    private void jCheckBoxLimitMaxXValueActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().getChartSettings().setPreventXAxisOverScaling(this.jCheckBoxLimitMaxXValue.isSelected());
        this.refreshGraphPreview();
    }

    private void jCheckBoxHideNonRepValuesActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxHideNonRepValues.isSelected()) {
            this.parent.getGraphPanelChart().getChartSettings().setHideNonRepValLimit(this.getValueFromString((String)this.jComboBoxHideNonRepValLimit.getSelectedItem()));
        } else {
            this.parent.getGraphPanelChart().getChartSettings().setHideNonRepValLimit(-1);
        }
        this.refreshGraphPreview();
    }

    private void jComboBoxHideNonRepValLimitActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxHideNonRepValues.isSelected()) {
            this.parent.getGraphPanelChart().getChartSettings().setHideNonRepValLimit(this.getValueFromString((String)this.jComboBoxHideNonRepValLimit.getSelectedItem()));
        }
        this.refreshGraphPreview();
    }

    private void jRadioButtonGraphAggregatedActionPerformed(ActionEvent evt) {
        this.parent.switchModel(true);
        this.refreshGraphPreview();
    }

    private void jRadioButtonGraphDetailedActionPerformed(ActionEvent evt) {
        this.parent.switchModel(false);
        this.refreshGraphPreview();
    }

    private void jCheckBoxRelativeTimeActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().setUseRelativeTime(this.jCheckBoxRelativeTime.isSelected());
    }

    private long getLongValue(String sLong) {
        long ret;
        try {
            ret = Long.valueOf(sLong);
        }
        catch (Exception ex) {
            ret = -1L;
        }
        return Math.max(ret, -1L);
    }

    private void jCheckBoxMaxYActionPerformed(ActionEvent evt) {
        long value = this.getLongValue(this.jTextFieldMaxY.getText());
        long oldValue = this.parent.getGraphPanelChart().getChartSettings().getForcedMaxY();
        if (value == -1L) {
            this.jTextFieldMaxY.setForeground(Color.red);
        } else {
            this.jTextFieldMaxY.setForeground(Color.black);
        }
        if (this.jCheckBoxMaxY.isSelected()) {
            this.parent.getGraphPanelChart().getChartSettings().setForcedMaxY(value);
            if (oldValue != value) {
                this.refreshGraphPreview();
            }
        } else {
            this.parent.getGraphPanelChart().getChartSettings().setForcedMaxY(-1L);
            if (oldValue != -1L) {
                this.refreshGraphPreview();
            }
        }
    }

    private void jLabelLogoMouseClicked(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) == 16) {
            JMeterPluginsUtils.openInBrowser("http://jmeter-plugins.org/wiki/?utm_source=jmeter&utm_medium=logolink&utm_campaign=" + this.parent.getWikiPage());
        }
    }

    private void jComboBoxChartTypeActionPerformed(ActionEvent evt) {
        int selectedType = this.jComboBoxChartType.getSelectedIndex();
        switch (selectedType) {
            case 0: {
                this.parent.getGraphPanelChart().getChartSettings().setChartType(1);
                this.jCheckBoxDrawMarkers.setVisible(true);
                this.jComboBoxLineWidth.setVisible(true);
                this.jLabelLineWidth.setVisible(true);
                break;
            }
            case 1: {
                this.parent.getGraphPanelChart().getChartSettings().setChartType(2);
                this.jCheckBoxDrawMarkers.setVisible(false);
                this.jComboBoxLineWidth.setVisible(false);
                this.jLabelLineWidth.setVisible(false);
                break;
            }
            case 2: {
                this.parent.getGraphPanelChart().getChartSettings().setChartType(3);
                this.jCheckBoxDrawMarkers.setVisible(true);
                this.jComboBoxLineWidth.setVisible(true);
                this.jLabelLineWidth.setVisible(true);
                break;
            }
            default: {
                this.parent.getGraphPanelChart().getChartSettings().setChartType(0);
            }
        }
        this.refreshGraphPreview();
    }

    private void jCheckBoxDrawMarkersActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxDrawMarkers.isSelected()) {
            this.parent.getGraphPanelChart().getChartSettings().setChartMarkers(1);
        } else {
            this.parent.getGraphPanelChart().getChartSettings().setChartMarkers(2);
        }
        this.refreshGraphPreview();
    }

    private void jCheckBoxAutoExpandActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().getChartSettings().setExpendRows(this.jCheckBoxAutoExpand.isSelected());
        this.refreshGraphPreview();
    }

    private void jComboBoxLineWidthActionPerformed(ActionEvent evt) {
        float lineWidth;
        try {
            lineWidth = Float.parseFloat(this.jComboBoxLineWidth.getSelectedItem().toString());
        }
        catch (NumberFormatException ex) {
            lineWidth = 1.0f;
        }
        this.parent.getGraphPanelChart().getChartSettings().setLineWidth(lineWidth);
        this.refreshGraphPreview();
    }

    @Override
    public boolean isPreview() {
        return true;
    }

    private void registerJTextfieldForRefresh(final JTextField tf) {
        tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                if (tf.hasFocus()) {
                    JSettingsPanel.this.jCheckBoxMaxYActionPerformed(null);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                if (tf.hasFocus()) {
                    JSettingsPanel.this.jCheckBoxMaxYActionPerformed(null);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                if (tf.hasFocus()) {
                    JSettingsPanel.this.jCheckBoxMaxYActionPerformed(null);
                }
            }
        });
    }
}

