/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root

/**
 * Implementation of DateTimeFormatInfo for the "ml" locale.
 */
public class DateTimeFormatInfoImpl_ml extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "am",
        "pm"
    };
  }

  @Override
  public String dateFormatFull() {
    return "y, MMMM d, EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "y, MMMM d";
  }

  @Override
  public String dateFormatMedium() {
    return "y, MMM d";
  }

  @Override
  public String dateFormatShort() {
    return "dd/MM/yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "ക്രിസ്തുവിനു് മുമ്പ്‌",
        "ക്രിസ്തുവിന് പിന്‍പ്"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "ക്രി.മൂ",
        "ക്രി.പി."
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "MMMM d, EEEE";
  }

  @Override
  public String formatMonthNumDay() {
    return "d-M";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y, MMMM d";
  }

  @Override
  public String formatYearMonthNum() {
    return "M-y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y MMM d, EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "yyyy QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "yyyy Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "ജനുവരി",
        "ഫെബ്രുവരി",
        "മാര്‍ച്ച്",
        "ഏപ്രില്‍",
        "മേയ്",
        "ജൂണ്‍",
        "ജൂലൈ",
        "ആഗസ്റ്റ്",
        "സെപ്റ്റംബര്‍",
        "ഒക്ടോബര്‍",
        "നവംബര്‍",
        "ഡിസംബര്‍"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "ജ",
        "ഫെ",
        "മാ",
        "ഏ",
        "മേ",
        "ജൂ",
        "ജൂ",
        "ഓ",
        "സെ",
        "ഒ",
        "ന",
        "ഡി"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "ജനു",
        "ഫെബ്രു",
        "മാര്‍",
        "ഏപ്രി",
        "മേയ്",
        "ജൂണ്‍",
        "ജൂലൈ",
        "ഓഗ",
        "സെപ്റ്റം",
        "ഒക്ടോ",
        "നവം",
        "ഡിസം"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "ഒന്നാം പാദം",
        "രണ്ടാം പാദം",
        "മൂന്നാം പാദം",
        "നാലാം പാദം"
    };
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "ഞായറാഴ്ച",
        "തിങ്കളാഴ്ച",
        "ചൊവ്വാഴ്ച",
        "ബുധനാഴ്ച",
        "വ്യാഴാഴ്ച",
        "വെള്ളിയാഴ്ച",
        "ശനിയാഴ്ച"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "ഞാ",
        "തി",
        "ചൊ",
        "ബു",
        "വ്യാ",
        "വെ",
        "ശ"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ഞായര്‍",
        "തിങ്കള്‍",
        "ചൊവ്വ",
        "ബുധന്‍",
        "വ്യാഴം",
        "വെള്ളി",
        "ശനി"
    };
  }

  @Override
  public int weekendStart() {
    return 0;
  }
}
