/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.nodes.AbstractNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.SimpleNodeIterator;

public class ObjectTag
extends CompositeTag {
    private static final String[] mIds = new String[]{"OBJECT"};
    private static final String[] mEndTagEnders = new String[]{"BODY", "HTML"};

    public String[] getIds() {
        return mIds;
    }

    public String[] getEndTagEnders() {
        return mEndTagEnders;
    }

    public Hashtable createObjectParamsTable() {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        NodeList kids = this.getChildren();
        if (null != kids) {
            for (int i = 0; i < kids.size(); ++i) {
                String paramName;
                Tag tag;
                Node node = ((AbstractNode)this).children.elementAt(i);
                if (!(node instanceof Tag) || !(tag = (Tag)node).getTagName().equals("PARAM") || null == (paramName = tag.getAttribute("NAME")) || 0 == paramName.length()) continue;
                String paramValue = tag.getAttribute("VALUE");
                ret.put(paramName.toUpperCase(), paramValue);
            }
        }
        return ret;
    }

    public String getObjectClassId() {
        return this.getAttribute("CLASSID");
    }

    public String getObjectCodeBase() {
        return this.getAttribute("CODEBASE");
    }

    public String getObjectCodeType() {
        return this.getAttribute("CODETYPE");
    }

    public String getObjectData() {
        return this.getAttribute("DATA");
    }

    public String getObjectHeight() {
        return this.getAttribute("HEIGHT");
    }

    public String getObjectStandby() {
        return this.getAttribute("STANDBY");
    }

    public String getObjectType() {
        return this.getAttribute("TYPE");
    }

    public String getObjectWidth() {
        return this.getAttribute("WIDTH");
    }

    public Hashtable getObjectParams() {
        return this.createObjectParamsTable();
    }

    public String getParameter(String key) {
        return (String)this.getObjectParams().get(key.toUpperCase());
    }

    public Enumeration getParameterNames() {
        return this.getObjectParams().keys();
    }

    public void setObjectClassId(String newClassId) {
        this.setAttribute("CLASSID", newClassId);
    }

    public void setObjectCodeBase(String newCodeBase) {
        this.setAttribute("CODEBASE", newCodeBase);
    }

    public void setObjectCodeType(String newCodeType) {
        this.setAttribute("CODETYPE", newCodeType);
    }

    public void setObjectData(String newData) {
        this.setAttribute("DATA", newData);
    }

    public void setObjectHeight(String newHeight) {
        this.setAttribute("HEIGHT", newHeight);
    }

    public void setObjectStandby(String newStandby) {
        this.setAttribute("STANDBY", newStandby);
    }

    public void setObjectType(String newType) {
        this.setAttribute("TYPE", newType);
    }

    public void setObjectWidth(String newWidth) {
        this.setAttribute("WIDTH", newWidth);
    }

    public void setObjectParams(Hashtable newObjectParams) {
        NodeList kids = this.getChildren();
        if (null == kids) {
            kids = new NodeList();
        } else {
            int i = 0;
            while (i < kids.size()) {
                Node node = kids.elementAt(i);
                if (node instanceof Tag) {
                    if (((Tag)node).getTagName().equals("PARAM")) {
                        TextNode string;
                        kids.remove(i);
                        if (i >= kids.size() || !((node = kids.elementAt(i)) instanceof TextNode) || 0 != (string = (TextNode)node).getText().trim().length()) continue;
                        kids.remove(i);
                        continue;
                    }
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        Enumeration e = newObjectParams.keys();
        while (e.hasMoreElements()) {
            Vector<Attribute> attributes = new Vector<Attribute>();
            String paramName = (String)e.nextElement();
            String paramValue = (String)newObjectParams.get(paramName);
            attributes.addElement(new Attribute("PARAM", null));
            attributes.addElement(new Attribute(" "));
            attributes.addElement(new Attribute("VALUE", paramValue, '\"'));
            attributes.addElement(new Attribute(" "));
            attributes.addElement(new Attribute("NAME", paramName.toUpperCase(), '\"'));
            TagNode tag = new TagNode(null, 0, 0, attributes);
            kids.add((Node)tag);
        }
        this.setChildren(kids);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(500);
        ret.append("Object Tag\n");
        ret.append("**********\n");
        ret.append("ClassId = ");
        ret.append(this.getObjectClassId());
        ret.append("\n");
        ret.append("CodeBase = ");
        ret.append(this.getObjectCodeBase());
        ret.append("\n");
        ret.append("CodeType = ");
        ret.append(this.getObjectCodeType());
        ret.append("\n");
        ret.append("Data = ");
        ret.append(this.getObjectData());
        ret.append("\n");
        ret.append("Height = ");
        ret.append(this.getObjectHeight());
        ret.append("\n");
        ret.append("Standby = ");
        ret.append(this.getObjectStandby());
        ret.append("\n");
        ret.append("Type = ");
        ret.append(this.getObjectType());
        ret.append("\n");
        ret.append("Width = ");
        ret.append(this.getObjectWidth());
        ret.append("\n");
        Hashtable parameters = this.getObjectParams();
        Enumeration params = parameters.keys();
        if (null == params) {
            ret.append("No Params found.\n");
        } else {
            int cnt = 0;
            while (params.hasMoreElements()) {
                String paramName = (String)params.nextElement();
                String paramValue = (String)parameters.get(paramName);
                ret.append(cnt);
                ret.append(": Parameter name = ");
                ret.append(paramName);
                ret.append(", Parameter value = ");
                ret.append(paramValue);
                ret.append("\n");
                ++cnt;
            }
        }
        boolean found = false;
        SimpleNodeIterator e = this.children();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            if (node instanceof Tag && ((Tag)node).getTagName().equals("PARAM")) continue;
            if (!found) {
                ret.append("Miscellaneous items :\n");
            } else {
                ret.append(" ");
            }
            found = true;
            ret.append(node.toString());
        }
        if (found) {
            ret.append("\n");
        }
        ret.append("End of Object Tag\n");
        ret.append("*****************\n");
        return ret.toString();
    }
}

