package com.tandbergtv.neptune.ui.realm.client.tab.user.service;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUser;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUserConfiguration;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUserList;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/realm/userService")
public interface UserUiService extends RemoteService {

	UiUserList listUsers(int startIndex, int pageSize, String sortByProperty, boolean isAscending)
	        throws NeptuneException;

	void deleteUsers(List<UiUserKey> userKeys) throws NeptuneException;

	UiUser getUser(UiUserKey userKey) throws NeptuneException;

	UiUser getUser(String userName) throws NeptuneException;

	UiUser saveUser(UiUser user) throws NeptuneException;

	/**
	 * Get all the supported roles that the user can be assigned to
	 * 
	 * @return The list of roles
	 * @throws NeptuneException
	 */
	List<UiRole> getRoles() throws NeptuneException;

	/**
	 * Get user configuration data
	 * 
	 * @return The configuration data
	 * @throws NeptuneException
	 */
	UiUserConfiguration getUserConfiguration() throws NeptuneException;

	/**
	 * Get the list of external users given the paging / sorting information
	 * 
	 * @param startIndex The 0-based index of the first record
	 * @param pageSize The maximum number of records to get
	 * @param sortByProperty The property to sort the records by
	 * @param isAscending The sort order to use
	 * @return The list of external users
	 * @throws NeptuneException
	 */
	UiUserList listExternalUsers(String filterCriteria, int startIndex, int pageSize,
	        String sortByProperty, boolean isAscending) throws NeptuneException;

	/**
	 * Get a single external user given the external user key
	 * 
	 * @param externalKey The key
	 * @return The external user
	 * @throws NeptuneException
	 */
	UiUser getExternalUser(String externalKey) throws NeptuneException;

	/**
	 * Static class to provide access to the RPC on the client. Do no use this on the server
	 * 
	 * @author Vijay Silva
	 */
	public static class Util {

		/**
		 * Get an instance of the service
		 * 
		 * @return The service
		 */
		public static UserUiServiceAsync getInstance() {
			return GWT.create(UserUiService.class);
		}
	}
}
