/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.State;
import java.util.ArrayList;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;

public class TypeSimplifier
extends SimpleTypeVisitor6<TypeMirror, State> {
    private final boolean boxPrimitives;

    public static TypeMirror simplify(TypeMirror toBox, boolean boxPrimitives, State state) {
        if (toBox == null) {
            return null;
        }
        return toBox.accept(new TypeSimplifier(boxPrimitives), state);
    }

    private TypeSimplifier(boolean boxPrimitives) {
        this.boxPrimitives = boxPrimitives;
    }

    @Override
    public TypeMirror visitDeclared(DeclaredType x, State state) {
        if (x.getTypeArguments().isEmpty()) {
            return x;
        }
        ArrayList<TypeMirror> newArgs = new ArrayList<TypeMirror>(x.getTypeArguments().size());
        for (TypeMirror typeMirror : x.getTypeArguments()) {
            if (typeMirror.getKind().equals((Object)TypeKind.TYPEVAR) && state.types.isAssignable(typeMirror, x)) {
                return state.types.getDeclaredType((TypeElement)x.asElement(), new TypeMirror[0]);
            }
            newArgs.add(typeMirror.accept(this, state));
        }
        return state.types.getDeclaredType((TypeElement)x.asElement(), newArgs.toArray(new TypeMirror[newArgs.size()]));
    }

    @Override
    public TypeMirror visitNoType(NoType x, State state) {
        if (this.boxPrimitives) {
            return state.findType(Void.class);
        }
        return x;
    }

    @Override
    public TypeMirror visitPrimitive(PrimitiveType x, State state) {
        if (this.boxPrimitives) {
            return state.types.boxedClass(x).asType();
        }
        return x;
    }

    @Override
    public TypeMirror visitTypeVariable(TypeVariable x, State state) {
        if (x.equals(x.getUpperBound())) {
            return state.types.erasure(x);
        }
        return x.getUpperBound().accept(this, state);
    }

    @Override
    public TypeMirror visitWildcard(WildcardType x, State state) {
        return state.types.erasure(x).accept(this, state);
    }

    @Override
    protected TypeMirror defaultAction(TypeMirror x, State state) {
        return state.types.getNoType(TypeKind.NONE);
    }
}

