/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ImportResource
extends Task {
    private Path m_classpath;
    private String m_resource;
    private boolean m_optional;

    public void setClasspath(Path cp) {
        if (this.m_classpath == null) {
            this.m_classpath = cp;
        } else {
            this.m_classpath.append(cp);
        }
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.getProject());
        }
        return this.m_classpath.createPath();
    }

    public void setOptional(boolean optional) {
        this.m_optional = optional;
    }

    public void setResource(String resource) {
        if (resource != null && resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        this.m_resource = resource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            File resourceFile;
            if (this.m_resource == null) {
                throw new BuildException("import requires resource attribute");
            }
            if (this.getOwningTarget() == null) throw new BuildException("import only allowed as a top-level task");
            if (!"".equals(this.getOwningTarget().getName())) {
                throw new BuildException("import only allowed as a top-level task");
            }
            Project p = this.getProject();
            ProjectHelper helper = (ProjectHelper)p.getReference("ant.projectHelper");
            Vector importStack = helper.getImportStack();
            if (importStack.size() == 0) {
                throw new BuildException("import requires support in ProjectHelper");
            }
            p.log("Importing resource " + this.m_resource, 3);
            if (this.m_classpath != null) {
                p.log("using user supplied classpath: " + this.m_classpath, 4);
                this.m_classpath = this.m_classpath.concatSystemClasspath("ignore");
            } else {
                this.m_classpath = new Path(p);
                this.m_classpath = this.m_classpath.concatSystemClasspath("only");
                p.log("using system classpath: " + this.m_classpath, 4);
            }
            AntClassLoader loader = new AntClassLoader(p.getCoreLoader(), p, this.m_classpath, false);
            URL resourceURL = loader.getResource(this.m_resource);
            if (resourceURL == null) {
                String message = "Cannot find resource " + this.m_resource;
                if (!this.m_optional) throw new BuildException(message);
                p.log(message, 3);
                return;
            }
            boolean isLocal = "file".equalsIgnoreCase(resourceURL.getProtocol());
            if (isLocal) {
                resourceFile = new File(resourceURL.getPath());
            } else {
                InputStream input = null;
                FileOutputStream output = null;
                try {
                    int count;
                    byte[] buffer = new byte[4096];
                    input = resourceURL.openStream();
                    resourceFile = File.createTempFile("import-", ".ant");
                    resourceFile.deleteOnExit();
                    output = new FileOutputStream(resourceFile);
                    while ((count = input.read(buffer)) > 0) {
                        ((OutputStream)output).write(buffer, 0, count);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new BuildException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        ImportResource.closeStream(input);
                        ImportResource.closeStream(output);
                        throw throwable;
                    }
                }
                ImportResource.closeStream(input);
                ImportResource.closeStream(output);
            }
            helper.parse(p, (Object)resourceFile);
            if (isLocal) return;
            resourceFile.delete();
            return;
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException((BuildException)ex, (Location)this.getLocation());
        }
    }

    private static void closeStream(OutputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void closeStream(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

