/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class LastRevision
extends Task {
    private String m_property;
    private String m_repositoryLocation;
    private String m_readerType;
    private String m_versionSelector;
    private File m_workingCopy;

    public void execute() throws BuildException {
        if (this.m_property == null) {
            throw new BuildException("\"property\" must be set", this.getLocation());
        }
        if (this.m_readerType == null) {
            throw new BuildException("\"readerType\" must be set", this.getLocation());
        }
        try {
            long revNo;
            IReaderType readerType = CorePlugin.getDefault().getReaderType(this.m_readerType);
            NullProgressMonitor nm = new NullProgressMonitor();
            if (this.m_repositoryLocation == null) {
                if (this.m_workingCopy == null) {
                    throw new BuildException("\"repositoryLocation\" or \"workingCopy\" must be set", this.getLocation());
                }
                if (this.m_versionSelector != null) {
                    throw new BuildException("\"versionSelector can only be used together with \"repositoryLocation\" are mutually exclusive", this.getLocation());
                }
                revNo = readerType.getLastRevision(this.m_workingCopy, (IProgressMonitor)nm);
            } else {
                if (this.m_workingCopy != null) {
                    throw new BuildException("\"repositoryLocation\" or \"workingCopy\" are mutually exclusive", this.getLocation());
                }
                VersionSelector versionSelector = null;
                if (this.m_versionSelector != null) {
                    versionSelector = VersionSelector.fromString((String)this.m_versionSelector);
                }
                revNo = readerType.getLastRevision(this.m_repositoryLocation, versionSelector, (IProgressMonitor)nm);
            }
            this.getProject().setProperty(this.m_property, Long.toString(revNo));
        }
        catch (Exception e) {
            Throwable c = BuckminsterException.unwind((Throwable)e);
            String msg = c.getMessage();
            if (msg == null) {
                msg = c.toString();
            }
            throw new BuildException(msg, c, this.getLocation());
        }
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public void setReaderType(String readerType) {
        this.m_readerType = readerType;
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.m_repositoryLocation = repositoryLocation;
    }

    public void setVersionSelector(String versionSelector) {
        this.m_versionSelector = versionSelector;
    }

    public void setWorkingCopy(File workingCopy) {
        this.m_workingCopy = workingCopy;
    }
}

