/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class LastTimestamp
extends Task {
    private String m_property;
    private String m_repositoryLocation;
    private String m_readerType;
    private String m_versionSelector;
    private String m_dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private String m_timeZone = "UTC";

    public void execute() throws BuildException {
        if (this.m_property == null) {
            throw new BuildException("\"property\" must be set", this.getLocation());
        }
        if (this.m_repositoryLocation == null) {
            throw new BuildException("\"repositoryLocation\" must be set", this.getLocation());
        }
        if (this.m_readerType == null) {
            throw new BuildException("\"readerType\" must be set", this.getLocation());
        }
        VersionSelector versionSelector = null;
        if (this.m_versionSelector != null) {
            versionSelector = VersionSelector.fromString((String)this.m_versionSelector);
        }
        Object versionFinder = null;
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(this.m_dateFormat);
            fmt.setTimeZone(TimeZone.getTimeZone(this.m_timeZone));
            NullProgressMonitor nm = new NullProgressMonitor();
            IReaderType readerType = CorePlugin.getDefault().getReaderType(this.m_readerType);
            this.getProject().setProperty(this.m_property, fmt.format(readerType.getLastModification(this.m_repositoryLocation, versionSelector, (IProgressMonitor)nm)));
        }
        catch (Exception e) {
            Throwable c = BuckminsterException.unwind((Throwable)e);
            String msg = c.getMessage();
            if (msg == null) {
                msg = c.toString();
            }
            throw new BuildException(msg, c, this.getLocation());
        }
        finally {
            if (versionFinder != null) {
                versionFinder.close();
            }
        }
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public void setDateFormat(String dateFormat) {
        this.m_dateFormat = dateFormat;
    }

    public void setTimeZone(String timeZone) {
        this.m_timeZone = timeZone;
    }

    public void setReaderType(String readerType) {
        this.m_readerType = readerType;
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.m_repositoryLocation = repositoryLocation;
    }

    public void setVersionSelector(String versionSelector) {
        this.m_versionSelector = versionSelector;
    }
}

