/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PropertySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChmod
extends Task {
    private static final Pattern s_fileAndPerm = Pattern.compile("^(.+):(\\d+)$");
    private final ArrayList<PropertySet> m_propertySets = new ArrayList();
    private File m_dir;

    public void execute() throws BuildException {
        HashMap<String, FileSet> entries = new HashMap<String, FileSet>();
        for (PropertySet propertySet : this.m_propertySets) {
            Properties props = propertySet.getProperties();
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                this.addAllEntries(entries, props.getProperty((String)propNames.nextElement()));
            }
        }
        Project p = this.getProject();
        for (Map.Entry entry : entries.entrySet()) {
            Chmod chmod = new Chmod();
            chmod.setProject(p);
            chmod.setPerm((String)entry.getKey());
            chmod.addFileset((FileSet)entry.getValue());
            chmod.perform();
            this.log("Changing to mode " + (String)entry.getKey() + " for files " + entry.getValue());
        }
    }

    public void addPropertySet(PropertySet propertySet) {
        this.m_propertySets.add(propertySet);
    }

    public void setDir(File dir) {
        this.m_dir = dir;
    }

    private void addAllEntries(Map<String, FileSet> entries, String propVal) throws BuildException {
        if (propVal == null || propVal.length() == 0) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(propVal, ",");
        while (tokens.hasMoreTokens()) {
            this.addEntry(entries, tokens.nextToken().trim());
        }
    }

    private void addEntry(Map<String, FileSet> entries, String propVal) throws BuildException {
        Matcher m = s_fileAndPerm.matcher(propVal);
        if (!m.matches()) {
            throw new BuildException("Illegal property value: " + propVal, this.getLocation());
        }
        Project p = this.getProject();
        String include = m.group(1);
        String perm = m.group(2);
        FileSet fs = entries.get(perm);
        if (fs == null) {
            fs = new FileSet();
            fs.setProject(p);
            fs.setDir(this.m_dir);
            entries.put(perm, fs);
        }
        fs.createInclude().setName(p.replaceProperties(include));
    }
}

