/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PackageNames
extends Task {
    private String m_property;
    private final ArrayList<FileSet> m_fileSets = new ArrayList();

    public void addFileset(FileSet fileSet) {
        this.m_fileSets.add(fileSet);
    }

    public void execute() throws BuildException {
        if (this.m_property == null) {
            throw new BuildException("\"property\" must be set");
        }
        if (this.m_fileSets.isEmpty()) {
            throw new BuildException("Please use at least one nested fileset");
        }
        Project antProj = this.getProject();
        HashSet<IPath> packages = new HashSet<IPath>();
        for (FileSet fileSet : this.m_fileSets) {
            DirectoryScanner ds = fileSet.getDirectoryScanner(antProj);
            File base = ds.getBasedir();
            for (String fileName : ds.getIncludedFiles()) {
                File file = new File(base, fileName);
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(file);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        Path entryPath;
                        JarEntry jarEntry = entries.nextElement();
                        if (jarEntry.isDirectory() || (entryPath = new Path(jarEntry.getName())).segmentCount() < 2 || "META-INF".equalsIgnoreCase(entryPath.segment(0))) continue;
                        packages.add(entryPath.removeLastSegments(1));
                    }
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e, this.getLocation());
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        StringBuilder bld = new StringBuilder(packages.size() * 30);
        for (IPath pkgPath : packages) {
            if (bld.length() > 0) {
                bld.append(',');
            }
            int top = pkgPath.segmentCount();
            bld.append(pkgPath.segment(0));
            for (int idx = 1; idx < top; ++idx) {
                bld.append('.');
                bld.append(pkgPath.segment(idx));
            }
        }
        antProj.setProperty(this.m_property, bld.toString());
    }

    public void setProperty(String property) {
        this.m_property = property;
    }
}

