/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PropertySet;
import org.eclipse.buckminster.ant.tasks.PerformTask;

public class Perform
extends Task {
    private boolean m_inWorkspace;
    private boolean m_quiet;
    private String m_component;
    private String m_attribute;
    private final ArrayList<PropertySet> m_propertySets = new ArrayList();

    public void execute() throws BuildException {
        Map<String, String> properties;
        if (this.m_component == null) {
            throw new BuildException("\"component\" must be set", this.getLocation());
        }
        if (this.m_attribute == null) {
            throw new BuildException("\"attribute\" must be set", this.getLocation());
        }
        if (this.m_propertySets.isEmpty()) {
            properties = Collections.emptyMap();
        } else {
            properties = new HashMap();
            for (PropertySet propertySet : this.m_propertySets) {
                Properties props = propertySet.getProperties();
                Enumeration<?> propNames = props.propertyNames();
                while (propNames.hasMoreElements()) {
                    String key = (String)propNames.nextElement();
                    properties.put(key, props.getProperty(key));
                }
            }
        }
        try {
            PerformTask executor = new PerformTask(this.m_component, this.m_attribute, this.m_inWorkspace, this.m_quiet, properties);
            int exitStatus = executor.execute();
            if (exitStatus != 0) {
                throw new BuildException("perform exited with " + exitStatus);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public void addPropertySet(PropertySet propertySet) {
        this.m_propertySets.add(propertySet);
    }

    public void setAttribute(String attribute) {
        this.m_attribute = attribute;
    }

    public void setQuiet(boolean flag) {
        this.m_quiet = flag;
    }

    public void setInWorkspace(boolean flag) {
        this.m_inWorkspace = flag;
    }

    public void setComponent(String component) {
        this.m_component = component;
    }
}

