/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Substitute
extends Task {
    private String m_property;
    private String m_pattern;
    private String m_replacement;
    private String m_value;
    private boolean m_quotePattern;

    public void execute() throws BuildException {
        if (this.m_property == null) {
            throw new BuildException("\"property\" must be set");
        }
        if (this.m_pattern == null) {
            throw new BuildException("\"pattern\" must be set");
        }
        if (this.m_replacement == null) {
            throw new BuildException("\"replacement\" must be set");
        }
        if (this.m_value == null) {
            throw new BuildException("\"value\" must be set");
        }
        try {
            Pattern pattern;
            Matcher matcher;
            String tmp = this.m_pattern;
            if (this.m_quotePattern) {
                tmp = Pattern.quote(tmp);
            }
            if ((matcher = (pattern = Pattern.compile(tmp)).matcher(this.m_value)).find()) {
                StringBuffer sb = new StringBuffer();
                do {
                    matcher.appendReplacement(sb, this.m_replacement);
                } while (matcher.find());
                matcher.appendTail(sb);
                tmp = sb.toString();
            } else {
                tmp = this.m_value;
            }
            this.getProject().setProperty(this.m_property, tmp);
        }
        catch (PatternSyntaxException e) {
            throw new BuildException(e.getMessage());
        }
    }

    public void setPattern(String pattern) {
        this.m_pattern = pattern;
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public void setQuotePattern(boolean flag) {
        this.m_quotePattern = flag;
    }

    public void setReplacement(String replacement) {
        this.m_replacement = replacement;
    }

    public void setValue(String value) {
        this.m_value = value;
    }
}

