/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import java.util.Collections;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.buckminster.ant.tasks.VersionQualifierTask;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionType;

public class VersionQualifier
extends Task {
    private String m_componentName;
    private String m_componentType;
    private File m_propertiesFile;
    private String m_property;
    private String m_qualifier;
    private String m_version;
    private String m_versionType;

    public void execute() throws BuildException {
        try {
            if (this.m_componentName == null) {
                throw new BuildException("Missing attribute componentName", this.getLocation());
            }
            if (this.m_version == null) {
                throw new BuildException("Missing attribute version", this.getLocation());
            }
            if (this.m_property == null) {
                throw new BuildException("Missing attribute property", this.getLocation());
            }
            IVersionType vt = CorePlugin.getDefault().getVersionType(this.m_versionType);
            IVersion v = vt.fromString(this.m_version);
            VersionQualifierTask vq = new VersionQualifierTask(this.m_propertiesFile, this.m_qualifier);
            ComponentIdentifier cid = new ComponentIdentifier(this.m_componentName, this.m_componentType, v);
            String prop = (v = vq.replaceQualifier(cid, Collections.emptyList())) == null ? this.m_version : v.toString();
            this.getProject().setUserProperty(this.m_property, prop);
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), this.getLocation());
        }
    }

    public void setComponentName(String componentName) {
        this.m_componentName = componentName;
    }

    public void setComponentType(String componentType) {
        this.m_componentType = componentType;
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public void setQualifier(String qualifier) {
        this.m_qualifier = qualifier;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.m_propertiesFile = propertiesFile == null || propertiesFile.length() == 0 ? null : new File(propertiesFile);
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public void setVersionType(String versionType) {
        this.m_versionType = versionType;
    }
}

