/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.types;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.eclipse.buckminster.core.helpers.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetGroup
extends DataType
implements Cloneable {
    private ArrayList<FileSet> m_fileSets;

    public void addFileset(FileSet fs) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.m_fileSets == null) {
            this.m_fileSets = new ArrayList();
        }
        this.m_fileSets.add(fs);
        this.setChecked(false);
    }

    public List<FileSet> getFileSets() {
        if (this.isReference()) {
            Object refObj = this.getRefid().getReferencedObject();
            if (refObj instanceof FileSetGroup) {
                return ((FileSetGroup)refObj).getFileSets();
            }
            throw new BuildException("Referenced object is not a FileSetGroup");
        }
        return this.m_fileSets == null ? Collections.emptyList() : this.m_fileSets;
    }

    public void setValue(String value) {
        if (value == null || value.length() < 1) {
            return;
        }
        StringTokenizer fileSetDecls = new StringTokenizer(value.substring(1), "?");
        while (fileSetDecls.hasMoreTokens()) {
            StringTokenizer tokens = new StringTokenizer(fileSetDecls.nextToken(), FileUtils.PATH_SEP);
            if (!tokens.hasMoreTokens()) continue;
            FileSet fs = new FileSet();
            fs.setProject(this.getProject());
            fs.setDir(new File(tokens.nextToken()));
            fs.setDefaultexcludes(true);
            while (tokens.hasMoreTokens()) {
                fs.createInclude().setName(tokens.nextToken());
            }
            this.addFileset(fs);
        }
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.m_fileSets != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }
}

