/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.internal.core.InternalCoreAntMessages;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntRunner {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static boolean s_buildRunning = false;
    private static final Class<?> s_internalAntRunnerClass;
    private static final Method s_addBuildLogger;
    private static final Method s_getBuildErrorMessage;
    private static final Method s_setBuildFileLocation;
    private static final Method s_setAntHome;
    private static final Method s_addUserProperties;
    private static final Method s_addPropertyFiles;
    private static final Method s_setArguments;
    private static final Method s_setProgressMonitor;
    private static final Method s_setMessageOutputLevel;
    private static final Method s_setExecutionTargets;
    private static final Method s_run;
    private String m_buildFileLocation = "build.xml";
    private String[] m_targets;
    private Map<String, String> m_userProperties;
    private String[] m_arguments;
    private String[] m_propertyFiles;
    private String m_antHome;
    private String m_buildLoggerClassName;

    static {
        try {
            Class[] string = new Class[]{String.class};
            Class[] strings = new Class[]{String[].class};
            s_internalAntRunnerClass = AntRunner.getInternalAntRunnerClass();
            s_addBuildLogger = s_internalAntRunnerClass.getMethod("addBuildLogger", string);
            s_getBuildErrorMessage = s_internalAntRunnerClass.getMethod("getBuildExceptionErrorMessage", Throwable.class);
            s_run = s_internalAntRunnerClass.getMethod("run", Trivial.EMPTY_CLASS_ARRAY);
            s_setBuildFileLocation = s_internalAntRunnerClass.getMethod("setBuildFileLocation", string);
            s_setAntHome = s_internalAntRunnerClass.getMethod("setAntHome", string);
            s_addUserProperties = s_internalAntRunnerClass.getMethod("addUserProperties", Map.class);
            s_addPropertyFiles = s_internalAntRunnerClass.getMethod("addPropertyFiles", strings);
            s_setArguments = s_internalAntRunnerClass.getMethod("setArguments", strings);
            s_setProgressMonitor = s_internalAntRunnerClass.getMethod("setProgressMonitor", IProgressMonitor.class);
            s_setMessageOutputLevel = s_internalAntRunnerClass.getMethod("setMessageOutputLevel", Integer.TYPE);
            s_setExecutionTargets = s_internalAntRunnerClass.getMethod("setExecutionTargets", strings);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError((Throwable)AntRunner.problemLoadingClass(e));
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static ClassLoader getClassLoader() {
        return AntCorePlugin.getPlugin().getNewClassLoader();
    }

    private static List<Property> getGlobalAntProperties() {
        return AntCorePlugin.getPlugin().getPreferences().getProperties();
    }

    private static Class<?> getInternalAntRunnerClass() throws ClassNotFoundException {
        ClassLoader loader = AntRunner.getClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        return loader.loadClass("org.eclipse.ant.internal.core.ant.InternalAntRunner");
    }

    static CoreException handleInvocationTargetException(Object runner, Class<?> classInternalAntRunner, InvocationTargetException e) {
        Throwable realException = e.getTargetException();
        if (realException instanceof OperationCanceledException) {
            return new CoreException(Status.CANCEL_STATUS);
        }
        String message = null;
        if (runner != null) {
            try {
                message = (String)s_getBuildErrorMessage.invoke(runner, realException);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (message == null && (realException instanceof NoClassDefFoundError || realException instanceof ClassNotFoundException)) {
            return AntRunner.problemLoadingClass(realException);
        }
        boolean internalError = false;
        if (message == null) {
            internalError = true;
            message = realException.getMessage() == null ? InternalCoreAntMessages.AntRunner_Build_Failed__3 : realException.getMessage();
        }
        Status status = new Status(4, "org.eclipse.ant.core", 1, message, realException);
        if (internalError) {
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        }
        return new CoreException((IStatus)status);
    }

    public static boolean isBuildRunning() {
        return s_buildRunning;
    }

    static CoreException problemLoadingClass(Throwable e) {
        String message;
        String missingClassName = e.getMessage();
        if (missingClassName != null) {
            missingClassName = missingClassName.replace('/', '.');
            message = InternalCoreAntMessages.AntRunner_Could_not_find_one_or_more_classes__Please_check_the_Ant_classpath__2;
            message = NLS.bind((String)message, (Object[])new String[]{missingClassName});
        } else {
            message = InternalCoreAntMessages.AntRunner_Could_not_find_one_or_more_classes__Please_check_the_Ant_classpath__1;
        }
        Status status = new Status(4, "org.eclipse.ant.core", 1, message, e);
        AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        return new CoreException((IStatus)status);
    }

    public void addUserProperties(Map<String, String> properties) {
        if (this.m_userProperties == null) {
            this.m_userProperties = new HashMap<String, String>(properties);
        } else {
            this.m_userProperties.putAll(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        Class<?> clazz = s_internalAntRunnerClass;
        synchronized (clazz) {
            Object runner = null;
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    int messageOutputLevel;
                    runner = s_internalAntRunnerClass.newInstance();
                    s_setBuildFileLocation.invoke(runner, this.m_buildFileLocation);
                    if (this.m_antHome != null) {
                        s_setAntHome.invoke(runner, this.m_antHome);
                    }
                    if (this.m_buildLoggerClassName == null) {
                        this.m_buildLoggerClassName = "";
                    }
                    s_addBuildLogger.invoke(runner, this.m_buildLoggerClassName);
                    if (this.m_userProperties != null) {
                        Map<String, String> allProps = this.m_userProperties;
                        List<Property> properties = AntRunner.getGlobalAntProperties();
                        if (properties != null) {
                            allProps = new HashMap<String, String>(this.m_userProperties);
                            for (Property property : properties) {
                                String value = property.getValue(true);
                                if (value == null) continue;
                                allProps.put(property.getName(), value);
                            }
                        }
                        s_addUserProperties.invoke(runner, allProps);
                    }
                    if (this.m_propertyFiles != null && this.m_propertyFiles.length > 0) {
                        s_addPropertyFiles.invoke(runner, new Object[]{this.m_propertyFiles});
                    }
                    if (this.m_arguments != null && this.m_arguments.length > 0) {
                        s_setArguments.invoke(runner, new Object[]{this.m_arguments});
                    }
                    if (monitor != null) {
                        s_setProgressMonitor.invoke(runner, monitor);
                    }
                    switch (BuckminsterPreferences.getLogLevelAntLogger()) {
                        case 0: {
                            messageOutputLevel = 4;
                            break;
                        }
                        case 2: {
                            messageOutputLevel = 1;
                            break;
                        }
                        case 4: {
                            messageOutputLevel = 0;
                            break;
                        }
                        default: {
                            messageOutputLevel = 2;
                        }
                    }
                    if (messageOutputLevel != 2) {
                        s_setMessageOutputLevel.invoke(runner, new Integer(messageOutputLevel));
                    }
                    if (this.m_targets != null) {
                        s_setExecutionTargets.invoke(runner, new Object[]{this.m_targets});
                    }
                    s_run.invoke(runner, Trivial.EMPTY_OBJECT_ARRAY);
                }
                catch (NoClassDefFoundError e) {
                    throw AntRunner.problemLoadingClass(e);
                }
                catch (InvocationTargetException e) {
                    throw AntRunner.handleInvocationTargetException(runner, s_internalAntRunnerClass, e);
                }
                catch (Exception e) {
                    String message = e.getMessage() == null ? InternalCoreAntMessages.AntRunner_Build_Failed__3 : e.getMessage();
                    Status status = new Status(4, "org.eclipse.ant.core", 1, message, (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            finally {
                s_buildRunning = false;
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public void setAntHome(String antHome) {
        this.m_antHome = antHome;
    }

    public void setArguments(String[] arguments) {
        this.m_arguments = arguments;
    }

    public void setBuildFileLocation(IPath buildFileLocation) {
        this.m_buildFileLocation = buildFileLocation == null ? "build.xml" : buildFileLocation.toOSString();
    }

    public void setBuildLogger(String className) {
        this.m_buildLoggerClassName = className;
    }

    public void setExecutionTargets(String[] executionTargets) {
        this.m_targets = executionTargets;
    }

    public void setPropertyFiles(String[] propertyFiles) {
        this.m_propertyFiles = propertyFiles;
    }
}

