/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.actor;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.eclipse.buckminster.ant.AntRunner;
import org.eclipse.buckminster.ant.Messages;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntActor
extends AbstractActor {
    public static final String ACTOR_ID = "ant";
    public static final String PROP_BUILD_FILE_ID = "buildFileId";
    public static final String PROP_TARGETS = "targets";
    public static final String PROP_BUILD_FILE = "buildFile";
    private static final String BUILD_SCRIPT_POINT = "org.eclipse.buckminster.ant.buildScripts";
    private static final String BUILD_SCRIPT_ID = "id";
    private static final String BUILD_SCRIPT_RESOURCE = "resource";

    private static void addPathGroupArraysToProperties(Map<String, PathGroup[]> namedPGA, Map<String, String> props) {
        if (namedPGA == null) {
            return;
        }
        StringBuilder sp_bld = new StringBuilder();
        StringBuilder fs_bld = new StringBuilder();
        StringBuilder key_bld = new StringBuilder();
        for (Map.Entry<String, PathGroup[]> namedPG : namedPGA.entrySet()) {
            PathGroup[] pathGroups = namedPG.getValue();
            boolean singleton = pathGroups.length == 1;
            fs_bld.setLength(0);
            sp_bld.setLength(0);
            PathGroup[] pathGroupArray = pathGroups;
            int n = pathGroups.length;
            int n2 = 0;
            while (n2 < n) {
                PathGroup pathGroup = pathGroupArray[n2];
                IPath basePath = pathGroup.getBase();
                String base = basePath.toOSString();
                fs_bld.append('?');
                fs_bld.append(base);
                IPath[] paths = pathGroup.getPaths();
                if (paths.length > 1) {
                    singleton = false;
                }
                if (singleton) {
                    sp_bld.append(base);
                }
                IPath[] iPathArray = paths;
                int n3 = paths.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath path = iPathArray[n4];
                    String osPath = path.toOSString();
                    fs_bld.append(FileUtils.PATH_SEP);
                    fs_bld.append(osPath);
                    if (singleton) {
                        if (!basePath.hasTrailingSeparator()) {
                            sp_bld.append(FileUtils.FILE_SEP);
                        }
                        sp_bld.append(osPath);
                    }
                    ++n4;
                }
                ++n2;
            }
            String propKey = namedPG.getKey();
            key_bld.setLength(0);
            key_bld.append("fs:");
            key_bld.append(propKey);
            props.put(key_bld.toString(), fs_bld.toString());
            if (!singleton) continue;
            key_bld.setLength(0);
            key_bld.append("sp:");
            key_bld.append(propKey);
            props.put(key_bld.toString(), sp_bld.toString());
        }
    }

    protected void addActorPathGroups(IActionContext ctx, Map<String, PathGroup[]> namedPathGroupArrays) throws CoreException {
    }

    protected final IPath getBuildFile(IActionContext ctx) throws CoreException {
        String buildFileId = this.getBuildFileIdProperty(ctx);
        String buildFile = this.getBuildFileProperty(ctx);
        if (buildFile == null) {
            if (buildFileId == null) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.AntActor_Property_not_set_0, (Object)PROP_BUILD_FILE), (Object[])new Object[0]);
            }
            buildFileId = (String)ExpandingProperties.expand((Map)ctx.getProperties(), (Object)buildFileId, (int)0);
            return this.getBuildFileExtension(buildFileId);
        }
        if (buildFileId != null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.AntActor_Properties_0_and_1_are_mutually_exclusive, (Object)PROP_BUILD_FILE, (Object)PROP_BUILD_FILE_ID), (Object[])new Object[0]);
        }
        buildFile = (String)ExpandingProperties.expand((Map)ctx.getProperties(), (Object)buildFile, (int)0);
        Path buildFilePath = new Path(buildFile);
        if (!buildFilePath.isAbsolute()) {
            buildFilePath = ctx.getComponentLocation().append((IPath)buildFilePath);
        }
        return buildFilePath;
    }

    protected String getBuildFileIdProperty(IActionContext ctx) throws CoreException {
        return TextUtils.notEmptyTrimmedString((String)this.getActorProperty(PROP_BUILD_FILE_ID));
    }

    protected String getBuildFileProperty(IActionContext ctx) throws CoreException {
        return TextUtils.notEmptyTrimmedString((String)this.getActorProperty(PROP_BUILD_FILE));
    }

    protected Map<String, String> getDefaultProperties(IActionContext ctx) throws CoreException {
        return Collections.emptyMap();
    }

    protected final String[] getTargets(IActionContext ctx) throws CoreException {
        String tlist = this.getTargetsString(ctx);
        if (tlist.length() == 0) {
            return null;
        }
        return tlist.split("\\s+");
    }

    protected final String getTargetsString(IActionContext ctx) {
        String tlist = this.getActorProperty(PROP_TARGETS);
        return tlist == null ? ctx.getAction().getName() : tlist.trim();
    }

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        monitor.beginTask(null, 100);
        monitor.subTask(ctx.getAction().getQualifiedName());
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        try {
            IPath buildFile = this.getBuildFile(ctx);
            ExpandingProperties props = new ExpandingProperties();
            for (Map.Entry entry : ctx.getProperties().entrySet()) {
                props.put((String)entry.getKey(), (Object)entry.getValue().toString());
            }
            props.putAll(this.getDefaultProperties(ctx));
            Map namedPathGroupArrays = ctx.getNamedPathGroupArrays();
            this.addActorPathGroups(ctx, namedPathGroupArrays);
            AntActor.addPathGroupArraysToProperties(namedPathGroupArrays, (Map<String, String>)props);
            props.put("basedir", (Object)ctx.getComponentLocation().toOSString());
            MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
            System.setOut(ctx.getOutputStream());
            System.setErr(ctx.getErrorStream());
            AntRunner runner = new AntRunner();
            runner.setBuildFileLocation(buildFile);
            runner.setExecutionTargets(this.getTargets(ctx));
            runner.setBuildLogger("org.eclipse.buckminster.ant.support.AntBuildLogger");
            runner.addUserProperties((Map<String, String>)props);
            runner.run(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OperationCanceledException e) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Error e) {
            Throwable t = BuckminsterException.unwind((Throwable)e);
            CorePlugin.getLogger().error(t, t.toString(), new Object[0]);
            throw e;
        }
        catch (RuntimeException e) {
            Throwable t = BuckminsterException.unwind((Throwable)e);
            CorePlugin.getLogger().error(t, t.toString(), new Object[0]);
            throw e;
        }
        catch (CoreException e) {
            Throwable t = BuckminsterException.unwind((Throwable)e);
            CorePlugin.getLogger().error(t, t.toString(), new Object[0]);
            throw e;
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
            monitor.done();
        }
    }

    private IPath getBuildFileExtension(String buildFileId) throws CoreException {
        IConfigurationElement resourceElem = null;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = er.getConfigurationElementsFor(BUILD_SCRIPT_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getAttribute(BUILD_SCRIPT_ID).equals(buildFileId)) {
                resourceElem = elem;
                break;
            }
            ++n2;
        }
        if (resourceElem == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.AntActor_No_extension_found_defines_0_1, (Object)PROP_BUILD_FILE_ID, (Object)buildFileId), (Object[])new Object[0]);
        }
        String contributor = resourceElem.getContributor().getName();
        Bundle contributorBundle = Platform.getBundle((String)contributor);
        if (contributorBundle == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.AntActor_Unable_to_load_bundle_0, (Object)contributor), (Object[])new Object[0]);
        }
        URL rsURL = contributorBundle.getResource(resourceElem.getAttribute(BUILD_SCRIPT_RESOURCE));
        if (rsURL == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.AntActor_Extension_found_using_0_1_appoints_non_existing_resource, (Object)PROP_BUILD_FILE_ID, (Object)buildFileId), (Object[])new Object[0]);
        }
        try {
            rsURL = FileLocator.toFileURL((URL)rsURL);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        if (!"file".equalsIgnoreCase(rsURL.getProtocol())) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.AntActor_Unexpected_protocol_0, (Object)rsURL.getProtocol()), (Object[])new Object[0]);
        }
        return FileUtils.getFileAsPath((URL)rsURL);
    }
}

