/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.internal.build;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.ant.AntBuilderConstants;
import org.eclipse.buckminster.ant.AntRunner;
import org.eclipse.buckminster.ant.Messages;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.build.AbstractBuckminsterBuilder;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntBuilder
extends AbstractBuckminsterBuilder
implements AntBuilderConstants {
    private IFile m_scriptFile;

    protected IProject[] doBuild(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        try {
            try {
                IPath baseDir;
                String[] stringArray;
                String target = this.getTarget(args, kind);
                if (target == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = target;
                }
                String[] targets = stringArray;
                String kindPropName = AbstractBuckminsterBuilder.getValue(args, (String)"build.kind.property");
                Map<String, String> props = this.getFixedProperties(args);
                if (kindPropName != null) {
                    props.put(kindPropName, AbstractBuckminsterBuilder.kindToString((int)kind));
                }
                if ((baseDir = this.getBaseDir(args)) != null) {
                    props.put("basedir", baseDir.toOSString());
                }
                System.setOut(this.getOutStream());
                System.setErr(this.getErrStream());
                AntRunner runner = new AntRunner();
                runner.setBuildFileLocation(this.getScriptFile(args).getLocation());
                runner.setExecutionTargets(targets);
                runner.setBuildLogger("org.eclipse.buckminster.ant.support.AntBuildLogger");
                runner.addUserProperties(props);
                runner.run(monitor);
            }
            catch (CoreException e) {
                CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
                throw e;
            }
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
        }
        return null;
    }

    protected IPath getBaseDir(Map<String, String> args) {
        String baseDir = AntBuilder.getValue(args, (String)"override.basedir");
        Path baseDirPath = null;
        if (baseDir != null && !(baseDirPath = new Path(baseDir)).isAbsolute()) {
            baseDirPath = this.getProject().getLocation().append((IPath)baseDirPath);
        }
        return baseDirPath;
    }

    protected Map<String, String> getFixedProperties(Map<String, String> args) {
        HashMap<String, String> props = new HashMap<String, String>();
        String componentPropName = AntBuilder.getValue(args, (String)"component.name.property");
        if (componentPropName != null) {
            props.put(componentPropName, this.getProject().getName());
        }
        return props;
    }

    protected IFile getScriptFile(Map<String, String> args) throws CoreException {
        if (this.m_scriptFile == null) {
            Path relativeScriptFilePath;
            String scriptFile = AntBuilder.getValue(args, (String)"script.file");
            if (scriptFile == null) {
                scriptFile = "buckminster.ant";
            }
            if ((relativeScriptFilePath = new Path(scriptFile)).isAbsolute()) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.AntBuilder_the_script_file_name_must_be_relative_to_the_project_root_0, (Object)scriptFile), (Object[])new Object[0]);
            }
            this.m_scriptFile = this.getProject().getFile((IPath)relativeScriptFilePath);
            this.notifyOnChangedResources(new IResource[]{this.m_scriptFile});
        }
        return this.m_scriptFile;
    }

    protected String getTarget(Map<String, String> args, int kind) {
        String target = null;
        if (kind == 9) {
            target = AntBuilder.getValue(args, (String)"auto.kind.target");
        } else if (kind == 15) {
            target = AntBuilder.getValue(args, (String)"clean.kind.target");
            if (target == null) {
                target = "clean";
            }
        } else if (kind == 6) {
            target = AntBuilder.getValue(args, (String)"full.kind.target");
        } else if (kind == 10) {
            target = AntBuilder.getValue(args, (String)"incremental.kind.target");
        }
        return target;
    }

    protected void resourcesChangeNotification(IResource[] changedResources) {
        IResource[] iResourceArray = changedResources;
        int n = changedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (r.equals((Object)this.m_scriptFile)) {
                this.forgetLastBuiltState();
                this.m_scriptFile = null;
                break;
            }
            ++n2;
        }
    }
}

