/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.ant.Messages;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.version.IQualifierGenerator;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionQualifierTask {
    public static final String GENERATOR_PREFIX = "generator:";
    public static final String QUALIFIER_SUFFIX = "qualifier";
    public static final String PROPERTY_CONTEXT = "context";
    public static final String PROPERTY_NONE = "none";
    private static final String QUALIFIER_REPLACEMENT_PREFIX = "qualifier.replacement.";
    private static final String MATCH_ALL = "qualifier.replacement.*";
    private static final SimpleDateFormat s_dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
    private final Map<String, ? extends Object> m_properties;
    private final String m_qualifier;

    public VersionQualifierTask(File propertiesFile, String qualifier) throws CoreException {
        this.m_qualifier = qualifier;
        Map globalProps = AbstractActor.getActiveContext().getProperties();
        if (propertiesFile == null) {
            this.m_properties = globalProps;
        } else {
            BufferedInputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(propertiesFile));
                    this.m_properties = new UnmodifiableMapUnion((Map)new BMProperties((InputStream)input), globalProps);
                }
                catch (IOException e) {
                    throw BuckminsterException.fromMessage((Throwable)e, (String)NLS.bind((String)Messages.VersionQualifierTask_Unable_to_read_properties_from_0, (Object)propertiesFile), (Object[])new Object[0]);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
            IOUtils.close((Closeable)input);
        }
    }

    public Map<String, ? extends Object> getProperties() {
        return this.m_properties;
    }

    public boolean isContextReplacement() {
        return this.m_qualifier == null || this.m_qualifier.equalsIgnoreCase(PROPERTY_CONTEXT);
    }

    public boolean isUsingGenerator(ComponentIdentifier ci) {
        IVersion version = ci.getVersion();
        if (version == null) {
            return false;
        }
        String qualifier = version.getQualifier();
        if (qualifier == null || !qualifier.endsWith(QUALIFIER_SUFFIX)) {
            return false;
        }
        String newQualifier = this.getQualifierReplacement(ci);
        return newQualifier != null && newQualifier.startsWith(GENERATOR_PREFIX);
    }

    public IVersion replaceQualifier(ComponentIdentifier ci, List<ComponentIdentifier> deps) {
        IVersion version = ci.getVersion();
        if (version == null) {
            return version;
        }
        String qualifier = version.getQualifier();
        if (qualifier == null) {
            return version;
        }
        if (!qualifier.endsWith(QUALIFIER_SUFFIX)) {
            return version;
        }
        String newQualifier = this.getQualifierReplacement(ci);
        if (newQualifier == null) {
            return version.replaceQualifier(null);
        }
        if (newQualifier.startsWith(GENERATOR_PREFIX)) {
            String generatorId = newQualifier.substring(GENERATOR_PREFIX.length());
            try {
                IQualifierGenerator generator = CorePlugin.getDefault().getQualifierGenerator(generatorId);
                version = generator.generateQualifier(AbstractActor.getActiveContext(), ci, deps);
            }
            catch (CoreException e) {
                CorePlugin.getLogger().warning((Throwable)e, Messages.VersionQualifierTask_Unable_to_qualify_version, new Object[0]);
            }
        } else if (!qualifier.equals(newQualifier = qualifier.replaceFirst(QUALIFIER_SUFFIX, newQualifier))) {
            version = version.replaceQualifier(newQualifier);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQualifierReplacement(ComponentIdentifier id) {
        String newQualifier = null;
        if (this.isContextReplacement()) {
            if (this.m_properties.size() != 0) {
                StringBuilder bld = new StringBuilder(QUALIFIER_REPLACEMENT_PREFIX);
                bld.append(id.getName());
                bld.append(',');
                int lenWithId = bld.length();
                String versionStr = id.getVersion().toString();
                bld.append(versionStr, 0, versionStr.length() - QUALIFIER_SUFFIX.length() - 1);
                newQualifier = (String)this.m_properties.get(bld.toString());
                if (newQualifier == null) {
                    bld.setLength(lenWithId);
                    bld.append("0.0.0");
                    newQualifier = (String)this.m_properties.get(bld.toString());
                    if (newQualifier == null) {
                        newQualifier = (String)this.m_properties.get(MATCH_ALL);
                    }
                }
            }
            if (newQualifier == null) {
                SimpleDateFormat simpleDateFormat = s_dateFormat;
                synchronized (simpleDateFormat) {
                    newQualifier = s_dateFormat.format(new Date());
                }
            }
        } else if (!this.m_qualifier.equalsIgnoreCase(PROPERTY_NONE)) {
            newQualifier = this.m_qualifier;
        }
        return newQualifier;
    }
}

