/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.cmdline.CommandInfo;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.cmdline.parser.ParseResult;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommand {
    private static final OptionDescriptor s_helpDescriptor = new OptionDescriptor('?', "help", 1);
    private String m_calledUsingName;
    private CommandInfo m_cmdInfo;
    private boolean m_addHelpFlags;

    public ProgressProvider getProgressProvider() {
        return new ProgressProvider(){

            public IProgressMonitor createMonitor(Job job) {
                return this.getDefaultMonitor();
            }
        };
    }

    public void init(boolean addHelpFlags) {
        this.m_addHelpFlags = addHelpFlags;
    }

    public int run(String cmdName) throws Exception {
        this.m_calledUsingName = cmdName;
        this.m_cmdInfo = CommandInfo.getCommand(cmdName);
        return this.run(this.getProgressProvider().getDefaultMonitor());
    }

    protected void beginOptionProcessing() throws Exception {
    }

    protected void endOptionProcessing() throws Exception {
    }

    protected String getCalledUsingName() throws Exception {
        return this.m_calledUsingName;
    }

    protected CommandInfo getCommandInfo() throws Exception {
        return this.m_cmdInfo;
    }

    protected String getFullName() throws Exception {
        return this.m_cmdInfo.getFullName();
    }

    protected InputStream getHelpStream() throws Exception {
        Class<?> myClass = this.getClass();
        String helpResource = "/" + myClass.getName().replace('.', '/') + ".help";
        return myClass.getResourceAsStream(helpResource);
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
    }

    protected void handleOption(Option option) throws Exception {
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
    }

    protected void help() throws Exception {
        this.help(this.getHelpStream());
    }

    protected void help(InputStream helpStream) throws Exception {
        if (helpStream == null) {
            System.err.println(NLS.bind((String)Messages.AbstractCommand_Help_missing_for_0, (Object)this.getFullName()));
        } else {
            try {
                System.out.print(NLS.bind((String)Messages.AbstractCommand_Help_text_for_0, (Object)this.getFullName()));
                IOUtils.copy((InputStream)helpStream, (OutputStream)System.out, null);
            }
            finally {
                IOUtils.close((Closeable)helpStream);
            }
            System.out.flush();
        }
    }

    protected abstract int run(IProgressMonitor var1) throws Exception;

    final int basicRun(String calledUsingName, CommandInfo cmdInfo, String[] commandArgs) throws Exception {
        block5: {
            this.m_calledUsingName = calledUsingName;
            this.m_cmdInfo = cmdInfo;
            ArrayList<OptionDescriptor> optionDescriptors = new ArrayList<OptionDescriptor>();
            this.getOptionDescriptors(optionDescriptors);
            if (this.m_addHelpFlags) {
                optionDescriptors.add(s_helpDescriptor);
            }
            try {
                boolean helpRequested = this.parseOptions(commandArgs, optionDescriptors);
                if (!helpRequested) break block5;
                this.help();
                return 0;
            }
            catch (UsageException e) {
                System.err.println(e.getMessage());
                if (e.isEmitHelp()) {
                    this.help();
                }
                return 1;
            }
        }
        return this.run(this.getProgressProvider().getDefaultMonitor());
    }

    private boolean parseOptions(String[] args, List<OptionDescriptor> optionDescriptors) throws Exception {
        ParseResult pr = ParseResult.parse(args, optionDescriptors);
        Option[] options = pr.getOptions();
        boolean helpRequested = false;
        this.beginOptionProcessing();
        int top = options.length;
        int idx = 0;
        while (idx < top) {
            Option option = options[idx];
            if (option.is(s_helpDescriptor)) {
                helpRequested = true;
            } else {
                this.handleOption(option);
            }
            ++idx;
        }
        this.endOptionProcessing();
        this.handleUnparsed(pr.getUnparsed());
        return helpRequested;
    }
}

