/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.CommandInfo;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.OptionValueType;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.cmdline.parser.CommandLineParser;
import org.eclipse.buckminster.cmdline.parser.InvalidOptionValueException;
import org.eclipse.buckminster.cmdline.parser.ParseResult;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class Headless
implements IApplication,
OptionValueType {
    public static final String PLUGIN_ID = "org.eclipse.buckminster.cmdline";
    public static final int EXIT_FORCED = 2;
    public static final int EXIT_FAIL = 1;
    public static final int EXIT_OK = 0;
    private static final OptionDescriptor DISPLAY_STACKTRACE = new OptionDescriptor(null, "displaystacktrace", 1);
    private static final OptionDescriptor HELP = new OptionDescriptor('?', "help", 1);
    private static final OptionDescriptor LOG_LEVEL = new OptionDescriptor('L', "loglevel", 3);
    private static final OptionDescriptor FILE = new OptionDescriptor('S', "scriptfile", 3);
    private final ArrayList<Invocation> m_invocations = new ArrayList();
    private boolean m_displayStackTrace = false;
    private boolean m_help = false;
    private boolean m_usingScript = false;
    private int m_logLevel = 1;

    protected void help(PrintStream ps) throws Exception {
        PrintStream out = System.out;
        InputStream is = this.getClass().getResourceAsStream("Headless.help");
        if (is == null) {
            out.println(Messages.Headless_Help_is_not_available);
        } else {
            out.println(Messages.Headless_Help_text_for_buckminster);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)out, null);
                out.flush();
            }
            finally {
                IOUtils.close((Closeable)is);
            }
        }
    }

    protected void parse(String[] args) throws Exception {
        ArrayList<OptionDescriptor> optionArr = new ArrayList<OptionDescriptor>();
        optionArr.add(DISPLAY_STACKTRACE);
        optionArr.add(FILE);
        optionArr.add(HELP);
        optionArr.add(LOG_LEVEL);
        ParseResult pr = ParseResult.parse(args, optionArr);
        String scriptFile = null;
        Option[] options = pr.getOptions();
        int top = options.length;
        int idx = 0;
        while (idx < top) {
            Option option = options[idx];
            if (option.is(HELP)) {
                this.m_help = true;
            } else if (option.is(DISPLAY_STACKTRACE)) {
                this.m_displayStackTrace = true;
            } else if (option.is(FILE)) {
                scriptFile = option.getValue();
            } else if (option.is(LOG_LEVEL)) {
                int logLevel;
                String arg = option.getValue();
                if ("info".equalsIgnoreCase(arg)) {
                    logLevel = 1;
                } else if ("warning".equalsIgnoreCase(arg)) {
                    logLevel = 2;
                } else if ("error".equalsIgnoreCase(arg)) {
                    logLevel = 4;
                } else if ("debug".equalsIgnoreCase(arg)) {
                    logLevel = 0;
                } else {
                    throw new InvalidOptionValueException(option.getName(), option.getValue());
                }
                this.m_logLevel = logLevel;
            } else {
                throw new InternalError(Messages.Headless_Unexpected_option);
            }
            ++idx;
        }
        String[] unparsed = pr.getUnparsed();
        if (unparsed.length > 0) {
            if (scriptFile != null) {
                throw new UsageException(Messages.Headless_The_scriptfile_option_cannot_be_combined_with_a_command, true);
            }
            String[] commandArgs = new String[unparsed.length - 1];
            System.arraycopy(unparsed, 1, commandArgs, 0, commandArgs.length);
            this.m_invocations.add(new Invocation(unparsed[0], commandArgs));
        } else if (scriptFile != null) {
            InputStream lines = null;
            try {
                String line;
                lines = scriptFile.equals("-") ? System.in : new FileInputStream(scriptFile);
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(lines));
                while ((line = reader.readLine()) != null) {
                    CommandLineParser tokenParser = new CommandLineParser(line);
                    if (!tokenParser.hasNext()) continue;
                    String command = tokenParser.next();
                    ArrayList<String> tokens = new ArrayList<String>();
                    while (tokenParser.hasNext()) {
                        tokens.add(tokenParser.next());
                    }
                    this.m_invocations.add(new Invocation(command, tokens.toArray(new String[tokens.size()])));
                    this.m_usingScript = true;
                }
            }
            finally {
                if (lines != System.in) {
                    IOUtils.close((Closeable)lines);
                }
            }
        }
    }

    public Object run(Object objArgs) throws Exception {
        Buckminster.setHeadless();
        int exitValue = 1;
        try {
            exitValue = this.run((String[])objArgs);
        }
        catch (OperationCanceledException e) {
            System.err.println(Messages.Headless_Command_canceled);
        }
        catch (InterruptedException e) {
            System.err.println(Messages.Headless_Command_was_interrupted);
        }
        catch (SimpleErrorExitException e) {
            System.err.println(e.getMessage());
            exitValue = e.getExitValue();
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
            if (e.isEmitHelp()) {
                this.help(System.out);
            }
        }
        catch (Throwable e) {
            BuckminsterException.deeplyPrint((Throwable)e, (PrintStream)System.err, (boolean)this.m_displayStackTrace);
        }
        return new Integer(exitValue);
    }

    protected int run(String[] args) throws Exception {
        this.parse(args);
        Logger.setConsoleLevelThreshold((int)this.m_logLevel);
        Logger.setEclipseLoggerLevelThreshold((int)this.m_logLevel);
        Logger.setEclipseLoggerToConsole((boolean)true);
        if (this.m_help) {
            this.help(System.out);
            return 0;
        }
        IJobManager jobMgr = Job.getJobManager();
        int top = this.m_invocations.size();
        if (top == 0) {
            System.out.println(Messages.Headless_No_command_provided_Try_one_of);
            System.out.println(Messages.Headless_buckminster__help);
            System.out.println(Messages.Headless_buckminster_listcommands);
            System.out.println(Messages.Headless_buckminster_command__help);
            return 1;
        }
        Logger logger = Buckminster.getLogger();
        int idx = 0;
        while (idx < top) {
            Invocation invocation = this.m_invocations.get(idx);
            String commandName = invocation.getName();
            CommandInfo ci = CommandInfo.getCommand(commandName);
            AbstractCommand cmd = ci.createInstance();
            jobMgr.setProgressProvider(cmd.getProgressProvider());
            if (logger.isDebugEnabled()) {
                logger.debug(invocation.toString(), new Object[0]);
            } else if (this.m_usingScript) {
                logger.info(invocation.toString(), new Object[0]);
            }
            int exitValue = cmd.basicRun(commandName, ci, invocation.getArgs());
            if (exitValue != 0) {
                return exitValue;
            }
            ++idx;
        }
        return 0;
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run(context.getArguments().get("application.args"));
    }

    public void stop() {
    }

    public static class Invocation {
        private final String m_name;
        private final String[] m_args;

        public Invocation(String name, String[] args) {
            this.m_name = name;
            this.m_args = args == null ? Trivial.EMPTY_STRING_ARRAY : args;
        }

        public String[] getArgs() {
            return this.m_args;
        }

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            int nargs = this.m_args.length;
            if (nargs == 0) {
                return this.m_name;
            }
            StringBuffer bld = new StringBuffer();
            bld.append(this.m_name);
            int idx = 0;
            while (idx < nargs) {
                bld.append(" '");
                bld.append(this.m_args[idx]);
                bld.append('\'');
                ++idx;
            }
            return bld.toString();
        }
    }
}

