/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline.parser;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParser
implements Iterator<String> {
    private final StringBuffer m_innerBld = new StringBuffer();
    private final StringBuffer m_outerBld = new StringBuffer();
    private final String m_line;
    private String m_nextToken;
    private int m_pos;

    @Deprecated
    private static String getenv(String varName) {
        try {
            return System.getenv(varName);
        }
        catch (Error e) {
            return Messages.CommandLineParser_ENV_Variables_not_supported_unless_Java_1_5_or_higher;
        }
    }

    private static char getEscapedChar(char escaped) {
        switch (escaped) {
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
        }
        return escaped;
    }

    public CommandLineParser(String line) {
        this.m_line = line;
        int top = this.m_line.length();
        while (this.m_pos < top) {
            char c = this.m_line.charAt(this.m_pos);
            if (Character.isWhitespace(c)) {
                ++this.m_pos;
                continue;
            }
            if (c != '#') break;
            this.m_pos = top;
            break;
        }
    }

    private void getExpanded(StringBuffer bld, String string) {
        Logger logger = Buckminster.getLogger();
        int top = string.length();
        int idx = 0;
        while (idx < top) {
            int end;
            int start;
            char c;
            if ((c = string.charAt(idx++)) != '$') {
                bld.append(c);
                continue;
            }
            if (idx == top) break;
            c = string.charAt(idx);
            if (c == '{') {
                start = ++idx;
                while (idx < top && string.charAt(idx) != '}') {
                    ++idx;
                }
                end = idx++;
            } else {
                start = idx;
                while (idx < top && Character.isJavaIdentifierPart(string.charAt(idx))) {
                    ++idx;
                }
                end = idx;
            }
            if (end <= start) continue;
            String key = string.substring(start, end);
            String value = key.length() > 4 && "env:".equalsIgnoreCase(string.substring(0, 4)) ? CommandLineParser.getenv(key.substring(4)) : System.getProperty(key);
            logger.debug("key '%s' expanded to '%s'", new Object[]{key, value});
            if (value == null) continue;
            bld.append(value);
        }
    }

    private String getQuoted(char quote) {
        this.m_innerBld.setLength(0);
        int top = this.m_line.length();
        while (this.m_pos < top) {
            char c;
            if ((c = this.m_line.charAt(this.m_pos++)) == quote) break;
            if (c == '\\') {
                if (this.m_pos == top) break;
                c = CommandLineParser.getEscapedChar(this.m_line.charAt(this.m_pos++));
            }
            this.m_innerBld.append(c);
        }
        return this.m_innerBld.toString();
    }

    private String getSpaceDelimited() {
        this.m_innerBld.setLength(0);
        int top = this.m_line.length();
        while (this.m_pos < top) {
            char c = this.m_line.charAt(this.m_pos);
            if (Character.isWhitespace(c) || c == '\'' || c == '\"') break;
            ++this.m_pos;
            if (c == '\\' && (this.m_pos == top || !Character.isWhitespace(c = this.m_line.charAt(this.m_pos++)) && Character.isWhitespace(c = CommandLineParser.getEscapedChar(c)))) break;
            this.m_innerBld.append(c);
        }
        return this.m_innerBld.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.m_nextToken == null) {
            this.m_nextToken = this.nextToken();
        }
        return this.m_nextToken != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String nxt = this.m_nextToken;
        this.m_nextToken = null;
        return nxt;
    }

    /*
     * Unable to fully structure code
     */
    private String nextToken() {
        this.m_outerBld.setLength(0);
        top = this.m_line.length();
        if (this.m_pos != top) ** GOTO lbl24
        return null;
lbl-1000:
        // 1 sources

        {
            c = this.m_line.charAt(this.m_pos);
            switch (c) {
                case '\'': {
                    ++this.m_pos;
                    this.m_outerBld.append(this.getQuoted('\''));
                    break;
                }
                case '\"': {
                    ++this.m_pos;
                    this.getExpanded(this.m_outerBld, this.getQuoted('\"'));
                    break;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        ++this.m_pos;
                        while (this.m_pos < top && Character.isWhitespace(this.m_line.charAt(this.m_pos))) {
                            ++this.m_pos;
                        }
                        break block4;
                    }
                    this.getExpanded(this.m_outerBld, this.getSpaceDelimited());
                }
            }
lbl24:
            // 4 sources

            ** while (this.m_pos < top)
        }
lbl25:
        // 2 sources

        return this.m_outerBld.toString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

