/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.IResolutionBuilder;
import org.eclipse.buckminster.core.ctype.MissingBuilderException;
import org.eclipse.buckminster.core.ctype.MissingComponentTypeException;
import org.eclipse.buckminster.core.helpers.ShortDurationURLCache;
import org.eclipse.buckminster.core.internal.actor.PerformManager;
import org.eclipse.buckminster.core.materializer.IMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationJob;
import org.eclipse.buckminster.core.materializer.WorkspaceBindingInstallJob;
import org.eclipse.buckminster.core.metadata.MetadataSynchronizer;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.parser.ParserFactory;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.MissingReaderTypeException;
import org.eclipse.buckminster.core.reader.RemoteFile;
import org.eclipse.buckminster.core.reader.RemoteFileCache;
import org.eclipse.buckminster.core.version.IQualifierGenerator;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.core.version.MissingMaterializerException;
import org.eclipse.buckminster.core.version.MissingVersionConverterException;
import org.eclipse.buckminster.core.version.MissingVersionTypeException;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.LogAwarePlugin;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.Utilities;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorePlugin
extends LogAwarePlugin {
    public static final String CORE_NAMESPACE = "org.eclipse.buckminster.core";
    public static final String ANT_TASK_GENERATORS = "org.eclipse.buckminster.core.anttaskGenerators";
    public static final String BOM_FILE = "buckminster.bom";
    public static final String COMPONENT_TYPE_POINT = "org.eclipse.buckminster.core.componentTypes";
    public static final String CQUERY_FILE = "buckminster.cquery";
    public static final String CSPEC_BUILDER_POINT = "org.eclipse.buckminster.core.cspecBuilders";
    public static final String CSPEC_FILE = "buckminster.cspec";
    public static final String CSPECEXT_FILE = "buckminster.cspex";
    public static final String OPML_FILE = "buckminster.opml";
    public static final String FORCED_ACTIVATIONS_POINT = "org.eclipse.buckminster.core.forcedActivations";
    public static final String QUALIFIER_GENERATOR_POINT = "org.eclipse.buckminster.core.qualifierGenerators";
    public static final String READER_TYPE_POINT = "org.eclipse.buckminster.core.readerTypes";
    public static final String VERSION_TYPES_POINT = "org.eclipse.buckminster.core.versionTypes";
    public static final String VERSION_CONVERTERS_POINT = "org.eclipse.buckminster.core.versionConverters";
    public static final String ACTORS_POINT = "org.eclipse.buckminster.core.actors";
    public static final String INTERNAL_ACTORS_POINT = "org.eclipse.buckminster.core.internalActors";
    public static final String BUCKMINSTER_PROJECT = ".buckminster";
    private static CorePlugin s_plugin;
    private final RemoteFileCache m_remoteFileCache = new RemoteFileCache(30000L, "bm-remote", ".cache", null);
    private ResourceBundle m_resourceBundle;
    private final Map<String, Map<String, Object>> m_singletonExtensionCache = new HashMap<String, Map<String, Object>>();
    private final ShortDurationURLCache m_urlCache = new ShortDurationURLCache();
    private WorkspaceJob m_updatePrefsJob;
    private IdentityHashMap<Object, ServiceReference> m_services;

    public static CorePlugin getDefault() {
        return s_plugin;
    }

    public static String getID() {
        return s_plugin.toString();
    }

    public static Logger getLogger() {
        CorePlugin plugin = s_plugin;
        if (plugin != null) {
            return plugin.getBundleLogger();
        }
        return new Logger(new ILog(){

            public void addLogListener(ILogListener listener) {
            }

            public Bundle getBundle() {
                return null;
            }

            public void log(IStatus status) {
                if (status == null) {
                    return;
                }
                switch (status.getSeverity()) {
                    case 2: 
                    case 4: {
                        System.err.println(status.getMessage());
                        break;
                    }
                    default: {
                        System.out.println(status.getMessage());
                    }
                }
            }

            public void removeLogListener(ILogListener listener) {
            }
        });
    }

    public static IPerformManager getPerformManager() throws CoreException {
        return PerformManager.getInstance();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static void logWarningsAndErrors(IStatus status) {
        CorePlugin.logWarningsAndErrors(status, new StringBuilder(), 0);
    }

    private static void logWarningsAndErrors(IStatus status, StringBuilder line, int indent) {
        switch (status.getSeverity()) {
            case 8: {
                throw new OperationCanceledException();
            }
            case 0: {
                break;
            }
            default: {
                Throwable reason;
                line.setLength(0);
                int idx = 0;
                while (idx < indent) {
                    line.append(' ');
                    ++idx;
                }
                String msg = status.getMessage();
                if (msg != null) {
                    line.append(msg);
                }
                if ((reason = status.getException()) != null) {
                    String reasonMsg = reason.getMessage();
                    if (reasonMsg == null) {
                        reasonMsg = reason.toString();
                    }
                    if (msg == null) {
                        line.append(reasonMsg);
                    } else if (!msg.equals(reasonMsg)) {
                        line.append(": ");
                        line.append(reasonMsg);
                    }
                }
                CorePlugin.getLogger().log(status.getSeverity(), line.toString(), new Object[0]);
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    CorePlugin.logWarningsAndErrors(child, line, indent + 2);
                    ++n2;
                }
                break block0;
            }
        }
    }

    public CorePlugin() {
        s_plugin = this;
    }

    public void clearRemoteFileCache() {
        this.m_remoteFileCache.clear();
    }

    public void clearURLCache() {
        this.m_urlCache.clear();
    }

    public UUID createUUID() {
        return UUID.randomUUID();
    }

    public IProject getBuckminsterProject(boolean createIfMissing, IProgressMonitor monitor) throws CoreException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject bmProject = wsRoot.getProject(BUCKMINSTER_PROJECT);
        boolean exists = bmProject.exists();
        if (exists) {
            if (!bmProject.isOpen()) {
                bmProject.open(monitor);
            } else {
                MonitorUtils.complete((IProgressMonitor)monitor);
            }
            return bmProject;
        }
        if (!createIfMissing) {
            return null;
        }
        monitor.beginTask(null, 2000);
        monitor.subTask("Creating .buckminster project");
        IPath path = this.getBuckminsterProjectLocation();
        IPath defaultLocation = wsRoot.getLocation().append(BUCKMINSTER_PROJECT);
        if (!path.equals((Object)defaultLocation)) {
            IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(BUCKMINSTER_PROJECT);
            desc.setLocation(path);
            bmProject.create(desc, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        } else {
            bmProject.create(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        }
        bmProject.open(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        monitor.done();
        return bmProject;
    }

    public IPath getBuckminsterProjectLocation() {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject bmProject = wsRoot.getProject(BUCKMINSTER_PROJECT);
        if (bmProject.exists()) {
            return bmProject.getLocation();
        }
        IPath path = BuckminsterPreferences.getBuckminterProjectContents();
        if (path == null) {
            path = wsRoot.getLocation().append(BUCKMINSTER_PROJECT);
        }
        return path;
    }

    public IComponentType getComponentType(String componentType) throws CoreException {
        IComponentType cType = this.getExecutableExtension(IComponentType.class, COMPONENT_TYPE_POINT, componentType, true);
        if (cType != null) {
            return cType;
        }
        throw new MissingComponentTypeException(componentType);
    }

    public <T> T getExecutableExtension(Class<T> instanceClass, String extensionPoint, String instanceId, boolean useSingleton) throws CoreException {
        IConfigurationElement[] elems;
        Object extension = null;
        Map<String, Object> singletonCache = null;
        if (useSingleton && (singletonCache = this.m_singletonExtensionCache.get(extensionPoint)) != null && (extension = singletonCache.get(instanceId)) != null) {
            return instanceClass.cast(extension);
        }
        IExtensionRegistry exReg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = exReg.getConfigurationElementsFor(extensionPoint);
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getAttribute("id").equals(instanceId)) {
                extension = elem.createExecutableExtension("class");
                if (useSingleton) {
                    if (singletonCache == null) {
                        singletonCache = new HashMap<String, Object>();
                        this.m_singletonExtensionCache.put(extensionPoint, singletonCache);
                    }
                    singletonCache.put(instanceId, extension);
                }
                return instanceClass.cast(extension);
            }
            ++n2;
        }
        return null;
    }

    public String[] getExtensionIds(String extensionPoint) {
        IExtensionRegistry exReg = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = exReg.getConfigurationElementsFor(extensionPoint);
        int idx = elems.length;
        String[] ids = new String[idx];
        while (--idx >= 0) {
            ids[idx] = elems[idx].getAttribute("id");
        }
        return ids;
    }

    public IMaterializer getMaterializer(String materializerId) throws CoreException {
        IMaterializer mat;
        if (materializerId == null) {
            materializerId = "workspace";
        }
        if ((mat = this.getExecutableExtension(IMaterializer.class, "org.eclipse.buckminster.core.materializers", materializerId, true)) != null) {
            return mat;
        }
        throw new MissingMaterializerException(materializerId);
    }

    public IParserFactory getParserFactory() {
        return ParserFactory.getDefault();
    }

    public IQualifierGenerator getQualifierGenerator(String qualifierGenerator) throws CoreException {
        IQualifierGenerator vm = this.getExecutableExtension(IQualifierGenerator.class, QUALIFIER_GENERATOR_POINT, qualifierGenerator, true);
        if (vm != null) {
            return vm;
        }
        throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Missing_qualifier_generator_for_id_0, (Object)qualifierGenerator), (Object[])new Object[0]);
    }

    public IReaderType getReaderType(String readerType) throws CoreException {
        IReaderType vm = this.getExecutableExtension(IReaderType.class, READER_TYPE_POINT, readerType, true);
        if (vm != null) {
            return vm;
        }
        throw new MissingReaderTypeException(readerType);
    }

    public IResolutionBuilder getResolutionBuilder(String id) throws CoreException {
        IResolutionBuilder builder = this.getExecutableExtension(IResolutionBuilder.class, CSPEC_BUILDER_POINT, id, false);
        if (builder != null) {
            return builder;
        }
        throw new MissingBuilderException(id);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.m_resourceBundle == null) {
                this.m_resourceBundle = ResourceBundle.getBundle("org.eclipse.buckminster.core.CorePluginResources");
            }
        }
        catch (MissingResourceException x) {
            this.m_resourceBundle = null;
        }
        return this.m_resourceBundle;
    }

    public <T> T getService(Class<T> serviceClass) throws CoreException {
        String serviceName;
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceRef = context.getServiceReference(serviceName = serviceClass.getName());
        if (serviceRef == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Missing_OSGi_Service_0, (Object)serviceName), (Object[])new Object[0]);
        }
        T service = serviceClass.cast(context.getService(serviceRef));
        if (this.m_services == null) {
            this.m_services = new IdentityHashMap();
        }
        this.m_services.put(service, serviceRef);
        return service;
    }

    public IVersionConverter getVersionConverter(String versionConverter) throws CoreException {
        IVersionConverter vc;
        if (versionConverter == null) {
            versionConverter = "tag";
        }
        if ((vc = this.getExecutableExtension(IVersionConverter.class, VERSION_CONVERTERS_POINT, versionConverter, false)) != null) {
            return vc;
        }
        throw new MissingVersionConverterException(versionConverter);
    }

    public IVersionType getVersionType(String versionType) throws CoreException {
        IVersionType vm;
        if (versionType == null) {
            versionType = "OSGi";
        }
        if ((vm = this.getExecutableExtension(IVersionType.class, VERSION_TYPES_POINT, versionType, true)) != null) {
            return vm;
        }
        throw new MissingVersionTypeException(versionType);
    }

    public InputStream openCachedRemoteFile(ICatalogReader reader, String fileName, IProgressMonitor monitor) throws IOException, CoreException {
        return this.m_remoteFileCache.openRemoteFile(new RemoteFile(reader, fileName), monitor);
    }

    public InputStream openCachedURL(URL url, IConnectContext cctx, IProgressMonitor monitor) throws IOException, CoreException {
        return this.m_urlCache.openURL(url, cctx, monitor);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Job startJob = new Job("Core plugin starter"){

            public IStatus run(IProgressMonitor monitor) {
                MetadataSynchronizer.setUp();
                MaterializationJob.setUp();
                Utilities.shutdown();
                IConfigurationElement[] forcedActivations = Platform.getExtensionRegistry().getConfigurationElementsFor(CorePlugin.FORCED_ACTIVATIONS_POINT);
                monitor.beginTask(null, forcedActivations.length);
                IConfigurationElement[] iConfigurationElementArray = forcedActivations;
                int n = forcedActivations.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement elem = iConfigurationElementArray[n2];
                    String pluginId = elem.getAttribute("pluginId");
                    try {
                        Bundle bundle = Platform.getBundle((String)pluginId);
                        bundle.loadClass(elem.getAttribute("class"));
                    }
                    catch (Exception e) {
                        CorePlugin.getLogger().warning((Throwable)e, NLS.bind((String)Messages.Unable_to_activate_bundle_0, (Object)pluginId), new Object[0]);
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
                WorkspaceBindingInstallJob.start();
                return Status.OK_STATUS;
            }
        };
        startJob.schedule(100L);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.m_services != null) {
            for (ServiceReference serviceRef : this.m_services.values()) {
                context.ungetService(serviceRef);
            }
            this.m_services = null;
        }
        MetadataSynchronizer.tearDown();
        this.stopAllJobs();
        this.m_urlCache.clear();
        this.m_singletonExtensionCache.clear();
        this.m_resourceBundle = null;
        s_plugin = null;
        super.stop(context);
    }

    public synchronized void stopAllJobs() throws Exception {
        if (this.m_updatePrefsJob != null) {
            this.m_updatePrefsJob.cancel();
            this.m_updatePrefsJob.join();
            this.m_updatePrefsJob = null;
        }
    }

    public void ungetService(Object service) {
        ServiceReference serviceRef;
        if (this.m_services != null && (serviceRef = this.m_services.remove(service)) != null) {
            this.getBundle().getBundleContext().ungetService(serviceRef);
        }
    }
}

