/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.ITargetPlatform;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetPlatform
extends AbstractExtension
implements ITargetPlatform {
    private static ITargetPlatform s_instance = null;
    public static final String TARGET_PLATFORM_PROVIDERS_POINT = "org.eclipse.buckminster.core.targetPlatformProviders";
    public static final String TARGET_PREFIX = "target";
    public static final String TARGET_OS = "target.os";
    public static final String TARGET_WS = "target.ws";
    public static final String TARGET_ARCH = "target.arch";
    public static final String TARGET_NL = "target.nl";
    public static final String TARGET_LOCATION = "target.location";

    public static synchronized ITargetPlatform getInstance() throws CoreException {
        if (s_instance == null) {
            IExtensionRegistry exReg = Platform.getExtensionRegistry();
            IConfigurationElement[] elems = exReg.getConfigurationElementsFor(TARGET_PLATFORM_PROVIDERS_POINT);
            IConfigurationElement candidate = null;
            int maxPrio = -1;
            IConfigurationElement[] iConfigurationElementArray = elems;
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                String prioStr = elem.getAttribute("priority");
                if (prioStr != null) {
                    try {
                        int prio = Integer.parseInt(prioStr);
                        if (prio > maxPrio) {
                            maxPrio = prio;
                            candidate = elem;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (candidate == null) {
                throw BuckminsterException.fromMessage((String)Messages.No_targetPlatformProvider_registered_with_targetPlatformProviders_extension_point, (Object[])new Object[0]);
            }
            s_instance = (ITargetPlatform)candidate.createExecutableExtension("class");
            CorePlugin.getLogger().debug("Target platform provided by %s", new Object[]{s_instance.getClass()});
        }
        return s_instance;
    }

    public static File getPlatformInstallLocation() {
        Location location = Platform.getInstallLocation();
        if (location == null) {
            return null;
        }
        URL eclipseHome = location.getURL();
        if (eclipseHome == null) {
            return null;
        }
        assert ("file".equals(eclipseHome.getProtocol()));
        return FileUtils.getFile(eclipseHome);
    }

    @Override
    public String getArch() {
        return Platform.getOSArch();
    }

    @Override
    public final List<ComponentIdentifier> getComponents() throws CoreException {
        return Collections.emptyList();
    }

    @Override
    public File getLocation() {
        return TargetPlatform.getPlatformInstallLocation();
    }

    @Override
    public String getNL() {
        return Platform.getNL();
    }

    @Override
    public String getOS() {
        return Platform.getOS();
    }

    @Override
    public String getWS() {
        return Platform.getWS();
    }
}

