/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractPreferencesCommand
extends WorkspaceCommand {
    private static final OptionDescriptor SCOPE_OPTION = new OptionDescriptor('S', "scope", 3);
    private static final OptionDescriptor FILE_OPTION = new OptionDescriptor('F', "file", 3);
    private IScopeContext m_scope;
    private HashMap<String, ArrayList<PreferenceFilterEntry>> m_includes;
    private File m_prefsFile;

    File getFile() {
        return this.m_prefsFile;
    }

    IPreferenceFilter[] getFilter() {
        HashMap<String, PreferenceFilterEntry[]> pfess = null;
        if (this.m_includes != null) {
            pfess = new HashMap<String, PreferenceFilterEntry[]>();
            for (Map.Entry<String, ArrayList<PreferenceFilterEntry>> entry : this.m_includes.entrySet()) {
                ArrayList<PreferenceFilterEntry> pfes = entry.getValue();
                if (pfes != null) {
                    pfess.put(entry.getKey(), pfes.toArray(new PreferenceFilterEntry[pfes.size()]));
                    continue;
                }
                pfess.put(entry.getKey(), null);
            }
        }
        PreferenceFilter filter = this.m_scope == null ? new PreferenceFilter(new String[]{"instance", "configuration"}, pfess) : new PreferenceFilter(new String[]{this.m_scope.getName()}, pfess);
        return new IPreferenceFilter[]{filter};
    }

    IEclipsePreferences getNode() {
        IPreferencesService prefService = Platform.getPreferencesService();
        IEclipsePreferences node = this.m_scope == null ? prefService.getRootNode() : (IEclipsePreferences)prefService.getRootNode().node(this.m_scope.getName());
        return node;
    }

    protected OptionDescriptor[] getOptionDescriptors() throws Exception {
        return new OptionDescriptor[]{SCOPE_OPTION, FILE_OPTION};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOption(Option option) throws Exception {
        if (option.is(SCOPE_OPTION)) {
            if (this.m_scope != null) {
                throw new UsageException(Messages.Only_one_scope_can_be_given);
            }
            String scopeName = option.getValue();
            if (scopeName.equalsIgnoreCase("instance")) {
                this.m_scope = new InstanceScope();
                return;
            } else {
                if (!scopeName.equalsIgnoreCase("configuration")) throw new UsageException(NLS.bind((String)Messages.Invalid_scope_Valid_scopes_are_0_and_1, (Object)"configuration", (Object)"instance"));
                this.m_scope = new ConfigurationScope();
            }
            return;
        } else {
            if (!option.is(FILE_OPTION)) return;
            if (this.m_prefsFile != null) {
                throw new UsageException(Messages.Only_one_file_can_be_given);
            }
            this.m_prefsFile = new File(option.getValue());
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length == 0) {
            return;
        }
        if (this.m_includes == null) {
            this.m_includes = new HashMap();
        }
        int idx = 0;
        while (idx < unparsed.length) {
            String include = unparsed[idx];
            String rootKey = null;
            String[] subKeys = null;
            int sepIdx = include.indexOf(35);
            if (sepIdx < 0 || sepIdx >= 1) {
                if (sepIdx < 0) {
                    rootKey = include.trim();
                } else {
                    rootKey = include.substring(0, sepIdx).trim();
                    subKeys = include.substring(sepIdx + 1).split(",");
                    if (subKeys.length == 0) {
                        subKeys = null;
                    }
                }
            }
            if (rootKey == null || rootKey.length() == 0) {
                throw new UsageException(NLS.bind((String)Messages.Illegal_include_0_Must_be_in_the_form, (Object)include));
            }
            if (subKeys == null) {
                this.m_includes.put(rootKey, null);
            } else {
                ArrayList<Object> pfes = this.m_includes.get(rootKey);
                if (pfes == null) {
                    pfes = new ArrayList();
                }
                int subIdx = 0;
                while (subIdx < subKeys.length) {
                    String subKey = subKeys[subIdx];
                    if ((subKey = subKey.trim()).length() != 0) {
                        pfes.add(new PreferenceFilterEntry(subKey));
                        if (!subKey.startsWith(rootKey)) {
                            pfes.add(new PreferenceFilterEntry(String.valueOf(rootKey) + '.' + subKey));
                        }
                    }
                    ++subIdx;
                }
                if (pfes.size() > 0) {
                    this.m_includes.put(rootKey, pfes);
                }
            }
            ++idx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PreferenceFilter
    implements IPreferenceFilter {
        private final String[] m_scopes;
        private final Map<String, PreferenceFilterEntry[]> m_mapping;

        PreferenceFilter(String[] scopes, Map<String, PreferenceFilterEntry[]> mapping) {
            this.m_scopes = scopes;
            this.m_mapping = mapping;
        }

        public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
            return this.m_mapping;
        }

        public String[] getScopes() {
            return this.m_scopes;
        }
    }
}

