/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.List;
import java.util.TreeMap;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Build
extends WorkspaceCommand {
    private static final OptionDescriptor s_cleanDescriptor = new OptionDescriptor('c', "clean", 1);
    private static final int MAX_INCREMENTAL_RETRY_COUNT = 3;
    private boolean m_clean = false;

    private String formatMarkerMessage(String type, IMarker problem) {
        StringBuilder bld = new StringBuilder();
        bld.append(type);
        bld.append(": file ");
        bld.append(problem.getResource().getLocation().toOSString());
        int line = problem.getAttribute("lineNumber", -1);
        if (line > 0) {
            bld.append(", line ");
            bld.append(line);
        }
        bld.append(": ");
        bld.append(problem.getAttribute("message", ""));
        return bld.toString();
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(s_cleanDescriptor);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(s_cleanDescriptor)) {
            this.m_clean = true;
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length > 0) {
            throw new UsageException(Messages.Too_many_arguments);
        }
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsRoot = ws.getRoot();
        IProject[] projs = wsRoot.getProjects();
        try {
            IMarker[] markers;
            int top;
            monitor.beginTask(null, projs.length * (this.m_clean ? 8 : 6));
            wsRoot.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)projs.length));
            if (this.m_clean) {
                ws.build(15, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)(projs.length * 2)));
            }
            ws.build(6, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)(projs.length * 5)));
            for (int retries = 0; (top = (markers = wsRoot.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)).length) != 0 && retries < 3; ++retries) {
                boolean retryNeeded = false;
                int idx = 0;
                while (idx < top) {
                    if (markers[idx].getAttribute("severity", 0) == 2) {
                        retryNeeded = true;
                        break;
                    }
                    ++idx;
                }
                if (!retryNeeded) break;
                ws.build(10, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)projs.length));
            }
            if (top == 0) {
                return 0;
            }
            TreeMap<Long, IMarker> problems = new TreeMap<Long, IMarker>();
            while (--top >= 0) {
                IMarker marker = markers[top];
                problems.put(marker.getCreationTime(), marker);
            }
            int exitValue = 0;
            for (IMarker problem : problems.values()) {
                switch (problem.getAttribute("severity", 0)) {
                    case 2: {
                        exitValue = 1;
                        System.err.println(this.formatMarkerMessage("Error", problem));
                        break;
                    }
                    case 1: {
                        System.err.println(this.formatMarkerMessage("Warning", problem));
                        break;
                    }
                    case 0: {
                        System.out.println(this.formatMarkerMessage("Info", problem));
                    }
                }
            }
            int n = exitValue;
            return n;
        }
        finally {
            monitor.done();
        }
    }
}

