/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.List;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.PreferenceMappingManager;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetPreference
extends AbstractCommand {
    private static final OptionDescriptor TEST_DESCRIPTOR = new OptionDescriptor(null, "__test", 1);
    private static final OptionDescriptor DEFAULT_DESCRIPTOR = new OptionDescriptor('d', "default", 3);
    private static final OptionDescriptor ONLYVALUE_DESCRIPTOR = new OptionDescriptor(null, "onlyvalue", 1);
    private boolean m_test = false;
    private boolean m_onlyValue = false;
    private String m_name;
    private String m_default;

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(TEST_DESCRIPTOR);
        appendHere.add(DEFAULT_DESCRIPTOR);
        appendHere.add(ONLYVALUE_DESCRIPTOR);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(TEST_DESCRIPTOR)) {
            this.m_test = true;
        } else if (option.is(DEFAULT_DESCRIPTOR)) {
            this.m_default = option.getValue();
        } else if (option.is(ONLYVALUE_DESCRIPTOR)) {
            this.m_onlyValue = true;
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 1) {
            throw new SimpleErrorExitException(Messages.Too_many_arguments);
        }
        if (len == 1) {
            this.m_name = unparsed[0];
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.m_name == null) {
            throw new SimpleErrorExitException(Messages.You_must_provide_a_preference_name);
        }
        BasicPreferenceHandler bph = PreferenceMappingManager.getInstance(this.m_test).getHandler(this.m_name);
        String v = bph.get(this.m_default);
        if (!this.m_onlyValue) {
            System.out.print(String.valueOf(bph.getName()) + "=");
        }
        if (v != null) {
            System.out.println(v);
        }
        return 0;
    }
}

