/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceInitCommand;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.MaterializationJob;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Import
extends WorkspaceInitCommand {
    private static final OptionDescriptor BOM_FILE = new OptionDescriptor('B', "bomfile", 3);
    private static final OptionDescriptor NO_IMPORT = new OptionDescriptor('N', "noimport", 1);
    private File m_bomFile;
    private boolean m_resolveOnly;
    private URL m_url;
    private IConnectContext m_connectContext;

    public void setBomFile(File bomFile) {
        this.m_bomFile = bomFile;
    }

    public void setConnectContext(IConnectContext cctx) {
        this.m_connectContext = cctx;
    }

    public void setResolveOnly(boolean flag) {
        this.m_resolveOnly = flag;
    }

    public void setURL(URL url) {
        this.m_url = url;
    }

    @Override
    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(NO_IMPORT);
        appendHere.add(BOM_FILE);
    }

    @Override
    protected void handleOption(Option option) throws Exception {
        if (option.is(NO_IMPORT)) {
            this.setResolveOnly(true);
        } else if (option.is(BOM_FILE)) {
            this.setBomFile(new File(option.getValue()));
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 1) {
            throw new UsageException(Messages.Too_many_arguments);
        }
        if (len < 1) {
            throw new UsageException(Messages.Missing_BOM_URL);
        }
        this.setURL(URLUtils.normalizeToURL((String)unparsed[0]));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected int internalRun(boolean continueOnError, IProgressMonitor monitor) throws Exception {
        block18: {
            logger = Buckminster.getLogger();
            MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
            bomOut = null;
            try {
                pf = CorePlugin.getDefault().getParserFactory();
                url = FileLocator.resolve((URL)this.m_url);
                byteBld = new AccessibleByteArrayOutputStream();
                DownloadManager.readInto((URL)url, (IConnectContext)this.m_connectContext, (OutputStream)byteBld, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                if (this.m_bomFile != null) {
                    bomOut = new BufferedOutputStream(new FileOutputStream(this.m_bomFile));
                }
                try {
                    mspec = pf.getMaterializationSpecParser(true).parse(url.toString(), byteBld.getInputStream());
                }
                catch (CoreException e) {
                    mspec = null;
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
                if (mspec != null) {
                    url = mspec.getResolvedURL();
                    byteBld.reset();
                    DownloadManager.readInto((URL)url, (IConnectContext)this.m_connectContext, (OutputStream)byteBld, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                } else {
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)20);
                }
                try {
                    cquery = ComponentQuery.fromStream(url, this.m_connectContext, byteBld.getInputStream(), true);
                }
                catch (CoreException e) {
                    cquery = null;
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
                if (cquery != null) {
                    ctx = new ResolutionContext(cquery);
                    if (mspec != null) {
                        for (Map.Entry<String, String> entry : mspec.getProperties().entrySet()) {
                            key = entry.getKey();
                            if (ctx.containsKey(key)) continue;
                            ctx.put(key, entry.getValue());
                        }
                    }
                    resolver = new MainResolver(ctx);
                    resolver.getContext().setContinueOnError(true);
                    bom = resolver.resolve(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                } else {
                    bom = pf.getBillOfMaterialsParser(true).parse(url.toString(), byteBld.getInputStream());
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                }
                if (bomOut != null) {
                    Utils.serialize((ISaxable)bom, (OutputStream)bomOut);
                    IOUtils.close((Closeable)bomOut);
                    bomOut = null;
                }
                if (!this.m_resolveOnly) break block18;
            }
            catch (Throwable var15_17) {
                IOUtils.close(bomOut);
                MonitorUtils.done((IProgressMonitor)monitor);
                throw var15_17;
            }
            IOUtils.close((Closeable)bomOut);
            MonitorUtils.done((IProgressMonitor)monitor);
            return 0;
        }
        if (mspec == null) {
            mspecBld = new MaterializationSpecBuilder();
            mspecBld.setURL(url.toString());
            mspecBld.setName(bom.getViewName());
            materializer = this.getMaterializer();
            if (materializer == null) {
                materializer = "workspace";
            }
            mspecBld.setMaterializerID(materializer);
            bom.addMaterializationNodes(mspecBld);
            mspec = mspecBld.createMaterializationSpec();
        }
        matCtx = new MaterializationContext(bom, mspec);
        matCtx.setContinueOnError(continueOnError);
        MaterializationJob.run(matCtx, true);
        ** if (!matCtx.emitWarningAndErrorTags()) goto lbl78
lbl-1000:
        // 1 sources

        {
            IOUtils.close((Closeable)bomOut);
            MonitorUtils.done((IProgressMonitor)monitor);
            return 1;
        }
        {
        }
lbl78:
        // 1 sources

        IOUtils.close((Closeable)bomOut);
        MonitorUtils.done((IProgressMonitor)monitor);
        logger.info(Messages.Import_complete, new Object[0]);
        return 0;
    }
}

