/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.AbstractPreferencesCommand;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.util.NLS;

public class ImportPreferences
extends AbstractPreferencesCommand {
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        InputStream input = null;
        File prefsFile = this.getFile();
        try {
            input = prefsFile == null ? System.in : new BufferedInputStream(new FileInputStream(prefsFile));
            IPreferencesService prefService = Platform.getPreferencesService();
            IExportedPreferences prefs = prefService.readPreferences(input);
            prefService.applyPreferences((IEclipsePreferences)prefs, this.getFilter());
            return 0;
        }
        catch (IOException e) {
            throw new SimpleErrorExitException(NLS.bind((String)Messages.ImportPreferences_Unable_to_open_file_0, (Object)prefsFile));
        }
        finally {
            if (prefsFile != null) {
                IOUtils.close((Closeable)input);
            }
        }
    }
}

